﻿# -*- encoding: utf-8 -*-
=begin
= 仲間に関する設定

==更新履歴
Date     Version Author Comment
  :actor_id => 仲間になるアクターID
  :denominator => 仲間になる確率分母(1/N)
  :question => 質問セリフ,
  :yes => 承諾セリフ,
  :no => 拒否セリフ,

従来の設定では:denominatorに-1を設定すると
判定無視で仲間になる仕様でしたが使っていないようなので廃止にしました
=end

#==============================================================================
# ■ NWConst::Follower
#==============================================================================
module NWConst::Follower  
  SETTINGS = {
    3 => { # バニースライム娘
      :actor_id => 54, :denominator => 1,
      :question => ["\\n<Bunny Slime>Hop hooop! Hey, take me with you too!", "bunnyslime_fc1", 0],
      :yes => ["\\n<Bunny Slime>Oh... You're that guy I fought back on the mountain... Oh well, nice to meet you♪", "bunnyslime_fc1", 1],
      :no => ["\\n<Bunny Slime>Wahh, you're mean!", "bunnyslime_fc1", 3],
    },
    4 => { # ナメクジ娘
      :actor_id => 55, :denominator => 2,
      :question => ["\\n<Slug Girl>...If it's all right with you, would you take me with you as well?", "name_fc1", 2],
      :yes => ["\\n<Slug Girl>Even though mine are slimy, shall we shake hands? ...Nice to meet you.", "name_fc1", 3],
      :no => ["\\n<Slug Girl>It's because I'm slimy isn't it?", "name_fc1", 1],
    },
    5 => { # インプ
      :actor_id => 56, :denominator => 2,
      :question => ["\\n<Imp>You guys seem nice♪\nHey, make me your companion too♪", "inp_fc1", 0],
      :yes => ["\\n<Imp>Ahahaa, nice to meet youuu! ♪\nOh, and could you help me find my friends? We got separated♪", "inp_fc1", 0],
      :no => ["\\n<Imp>Meanie...", "inp_fc1", 3],
    },
    6 => { # マンドラゴラ娘
      :actor_id => 59, :denominator => 3,
      :question => ["\\n<Mandragora>Hey, hey, could you make me your companion too? ...If you don't, I'll scream.", "mdg_fc1", 0],
      :yes => ["\\n<Mandragora>I'll follow you anywhere, buried in the ground.", "mdg_fc1", 0],
      :no => ["\\n<Mandragora>Ahhhhhhhhhhhhhhh...", "mdg_fc1", 2],
    },
    7 => { # 犬娘
      :actor_id => 60, :denominator => 3,
      :question => ["\\n<Dog Girl>Take me, woof, woof!", "dog_fc1", 0],
      :yes => ["\\n<Dog Girl>I'll follow you anywhere!", "dog_fc1", 1],
      :no => ["\\n<Dog Girl>*Whimper* *Whimper*", "dog_fc1", 2],
    },
    8 => { # ミミズ娘
      :actor_id => 61, :denominator => 3,
      :question => ["\\n<Earthworm Girl>Hey, will you take me along too?", "mimizu_fc1", 0],
      :yes => ["\\n<Earthworm Girl>Fufuu, I'll prove how strong earthworms are.", "mimizu_fc1", 1],
      :no => ["\\n<Earthworm Girl>If I dry out after this, it'll be your fault...", "mimizu_fc1", 2],
    },
    13 => { # ネズミ娘
      :actor_id => 70, :denominator => 3,
      :question => ["\\n<Rat Girl>If I stick with you, will I get to eat tasty food?", "nezumi_fc1", 1],
      :yes => ["\\n<Rat Girl>Yippee! I'll work really hard!", "nezumi_fc1", 1],
      :no => ["\\n<Rat Girl>Okay... I am a rat, after all.", "nezumi_fc1", 0],
    },
    14 => { # 狼娘
      :actor_id => 71, :denominator => 2,
      :question => ["\\n<Wolf Girl>Rawr! Take me with you! My fangs and claws will be handy!", "okami_fc1", 0],
      :yes => ["\\n<Wolf Girl>Awooo! I'll tear your enemies apart!", "okami_fc1", 3],
      :no => ["\\n<Wolf Girl>Grrrrrr... You're stingy...", "okami_fc1", 2],
    },
    16 => { # ヒル娘
      :actor_id => 73, :denominator => 3,
      :question => ["\\n<Leech Girl>I want to suck the fluids from lots of monsters. Hey, will you take me on your adventure too?", "hiru_fc1", 0],
      :yes => ["\\n<Leech Girl>Fufuu, nice to meet you.", "hiru_fc1", 1],
      :no => ["\\n<Leech Girl>...I'm going to squeeze out the fluids of all the local men.", "hiru_fc1", 2],
    },
    17 => { # ウサギ娘
      :actor_id => 74, :denominator => 1,
      :question => ["\\n<Rabbit Girl>You're really strong. Hey, will you make big sis a companion too?", "usagi_fc1", 0],
      :yes => ["\\n<Rabbit Girl>Well then, I'll stand by you starting today. Fufuu, nice to meet you.", "usagi_fc1", 3],
      :no => ["\\n<Rabbit Girl>Oh my, so your current companions are good enough, huh...", "usagi_fc1", 2],
    },
    18 => { # 羊娘
      :actor_id => 75, :denominator => 2,
      :question => ["\\n<Sheep Girl>Eyyy, will you take me?", "hituzi_fc1", 0],
      :yes => ["\\n<Sheep Girl>Uehihi, let's drink together! ♪", "hituzi_fc1", 3],
      :no => ["\\n<Sheep Girl>Then I'll drink on my own!", "hituzi_fc1", 2],
    },
    19 => { # シュリー
      :actor_id => 76, :denominator => 4,
      :question => ["\\n<Sully>I want adventure outside too! Hey, take me with youuu!", "syuree_fc1", 0],
      :yes => ["\\n<Sully>Yay! I get to see the outside world!", "syuree_fc1", 1],
      :no => ["\\n<Sully>I'm tired of this plaaace... I want to go outsiiide...", "syuree_fc1", 3],
    },
    20 => { # ジェイド
      :actor_id => 77, :denominator => 4,
      :question => ["\\n<Jaide>I would like to accompany you.", "jeid_fc1", 0],
      :yes => ["\\n<Jaide>Permission to accompany received. I can proceed outside.", "jeid_fc1", 0],
      :no => ["\\n<Jaide>Permission to accompany could not be obtained. The usual patrol will continue.", "jeid_fc1", 2],
    },
    21 => { # シェスタ
      :actor_id => 78, :denominator => 4,
      :question => ["\\n<Shesta>My memories... I can't remember...\nI want to search... for what I am...", "syesta_fc1", 0],
      :yes => ["\\n<Shesta>Tell me, what am I...?", "syesta_fc1", 1],
      :no => ["\\n<Shesta>I am... I don't know...", "syesta_fc1", 2],
    },
    23 => { # オーク娘
      :actor_id => 80, :denominator => 2,
      :question => ["\\n<Orc Girl>Oink, will you give me delicious things to eat?", "orc_fc1", 0],
      :yes => ["\\n<Orc Girl>Orc will be your companion! Room and board are assured! Yippee!", "orc_fc1", 1],
      :no => ["\\n<Orc Girl>Oink...", "orc_fc1", 2],
    },
    24 => { # ミツバチ娘
      :actor_id => 81, :denominator => 2,
      :question => ["\\n<Bee Girl>Wouldn't you like to taste my honey later on in your journey too? Take me, and I'll give you my honey.", "mitubati_fc1", 0],
      :yes => ["\\n<Bee Girl>Fufuu... Please enjoy plenty of my sweet nectar.", "mitubati_fc1", 1],
      :no => ["\\n<Bee Girl>You don't want my honey? Well that's disappointing...", "mitubati_fc1", 2],
    },
    25 => { # スズメ娘
      :actor_id => 82, :denominator => 2,
      :question => ["\\n<Sparrow Girl>U-umm... Would you please make me your companion too?", "suzume_fc1", 0],
      :yes => ["\\n<Sparrow Girl>R-really? I'm so happy!", "suzume_fc1", 1],
      :no => ["\\n<Sparrow Girl>Th-that's all right... Sparrows aren't very strong, are they?", "suzume_fc1", 2],
    },
    26 => { # ハーピー
      :actor_id => 83, :denominator => 2,
      :question => ["\\n<Harpy>Hey, hey, take me on your adventure too!", "hapy_a_fc1", 0],
      :yes => ["\\n<Harpy>Aha! If it's with you, I'll go anywhere!", "hapy_a_fc1", 1],
      :no => ["\\n<Harpy>That's okay... I can fly by myself...", "hapy_a_fc1", 2],
    },
    27 => { # ハーピーツインズ
      :actor_id => 84, :denominator => 3,
      :question => ["\\n<Harpy Sisters>Hey, Pii says she wants to travel with you.\n...Of course, as her guardian, I'll come too.", "hapy_bc_fc1", 0],
      :yes => ["\\n<Harpy Sisters>Good for you, Pii.", "hapy_bc_fc1", 1],
      :no => ["\\n<Harpy Sisters>...It didn't work out, Pii.", "hapy_bc_fc1", 2],
    },
    29 => { # ハイスラッグ娘
      :actor_id => 85, :denominator => 3,
      :question => ["\\n<High Slug>Fufuu, will you be my escort?", "highslag_fc1", 0],
      :yes => ["\\n<High Slug>Fufufuu, you're a good boy... As a reward, I'll give you some sticky-sticky.", "highslag_fc1", 1],
      :no => ["\\n<High Slug>What a rude boy...", "highslag_fc1", 2],
    },
    30 => { # ナメクジシスター
      :actor_id => 86, :denominator => 4,
      :question => ["\\n<Slug Nun>I'm a mucus-covered sister, but may I join you? I want to spread the teachings of Ilias all over the world.", "name_s_fc1", 0],
      :yes => ["\\n<Slug Nun>Well then, I will accompany you from now on. It's a pleasure to meet you, fufufuu...", "name_s_fc1", 1],
      :no => ["\\n<Slug Nun>Is that so? That's unfortunate. Slimy sisters seem to be unpopular...", "name_s_fc1", 2],
    },
    32 => { # ジャックオーランタン
      :actor_id => 88, :denominator => 2,
      :question => ["\\n<Jack O Lantern>I also want to be an adventurer. Umm, will you make me your companion?", "jack_fc1", 0],
      :yes => ["\\n<Jack O Lantern>Nice to meet you. I'll follow you anywhere.", "jack_fc1", 1],
      :no => ["\\n<Jack O Lantern>I-I'm sorry...", "jack_fc1", 2],
    },
    33 => { # ローパー娘
      :actor_id => 89, :denominator => 4,
      :question => ["\\n<Roper Girl>I'm hungry... Will you take me somewhere that has food?", "ropa_fc1", 0],
      :yes => ["\\n<Roper Girl>Let me eat a lot. Fufufuu...", "ropa_fc1", 1],
      :no => ["\\n<Roper Girl>I'm hungry...", "ropa_fc1", 2],
    },
    34 => { # メーダ娘
      :actor_id => 90, :denominator => 4,
      :question => ["\\n<Meda>*Rustle Rustle* *Creep Creep Creep*", "meda_fc1", 0],
      :yes => ["\\n<Meda>*Creep Creep* ...Nice to meet you.", "meda_fc1", 0],
      :no => ["\\n<Meda>*Slink Slink Slink*", "meda_fc1", 0],
    },
    35 => { # キャンドル娘
      :actor_id => 91, :denominator => 4,
      :question => ["\\n<Candle Girl>I want to see the world while I yet live... My wish... Won't you grant it...?", "candle_fc1", 0],
      :yes => ["\\n<Candle Girl>Fufuu, thank you... That said, I'm actually undead, so I won't die.", "candle_fc1", 1],
      :no => ["\\n<Candle Girl>You won't listen to my last request...", "candle_fc1", 2],
    },
    36 => { # イーター
      :actor_id => 92, :denominator => 4,
      :question => ["\\n<Eater>Hey, take me to the outside world!", "eater_fc1", 0],
      :yes => ["\\n<Eater>Yaaay! I get to eat a lot!", "eater_fc1", 3],
      :no => ["\\n<Eater>I don't want to stay here, I want to go outside...", "eater_fc1", 2],
    },
    37 => { # ライオット
      :actor_id => 93, :denominator => 4,
      :question => ["\\n<Riot>Take me with you. I've had enough of rioting in this place...", "liot_fc1", 0],
      :yes => ["\\n<Riot>What kind of strong people live in the outside world?", "liot_fc1", 4],
      :no => ["\\n<Riot>Geez, I'm bored of everything in this world...", "liot_fc1", 2],
    },
    38 => { # ルクスル
      :actor_id => 94, :denominator => 4,
      :question => ["\\n<Luxuru>Ahaa, please take me along too. I'll suck everything from your enemies...", "luksl_fc1", 0],
      :yes => ["\\n<Luxuru>Ahahaa, it's a pleasure! Ahahahahahaa!", "luksl_fc1", 1],
      :no => ["\\n<Luxuru>Ahahahahaa! Interesting!", "luksl_fc1", 1],
    },
    39 => { # ダークエルフ
      :actor_id => 95, :denominator => 3,
      :question => ["\\n<Dark Elf Fencer>I won't get bored if I'm with you. Don't you think my sword would be useful?", "delh_a_fc1", 1],
      :yes => ["\\n<Dark Elf Fencer>Fufuu, it's decided. You can rely on my blade from now on.", "delh_a_fc1", 1],
      :no => ["\\n<Dark Elf Fencer>You don't need my sword?!", "delh_a_fc1", 2],
    },
    40 => { # ダークエルフ
      :actor_id => 96, :denominator => 4,
      :question => ["\\n<Dark Elf Mage>My tentacles seek more nourishment. If I follow you, I'll be able to suck out plenty.", "delh_b_fc1", 0],
      :yes => ["\\n<Dark Elf Mage>Fufuu, let's get along from now on. I'll squeeze all of your enemies.", "delh_b_fc1", 1],
      :no => ["\\n<Dark Elf Mage>I see. That's unfortunate...", "delh_b_fc1", 2],
    },
    41 => { # フェアリー
      :actor_id => 97, :denominator => 2,
      :question => ["\\n<Fairy>Hey, hey, I want to go on an adventure too♪", "fairy_fc1", 0],
      :yes => ["\\n<Fairy>Yaaay! Nice to meet you♪", "fairy_fc1", 0],
      :no => ["\\n<Fairy>Meanie...", "fairy_fc1", 2],
    },
    42 => { # ミニカニ娘
      :actor_id => 98, :denominator => 4,
      :question => ["\\n<Mini Crab Girl>Yaay! I want to adventure together too! ♪", "minikani_fc1", 0],
      :yes => ["\\n<Mini Crab Girl>Ahahaa, nice to meet youuu!", "minikani_fc1", 0],
      :no => ["\\n<Mini Crab Girl>Uh! Waaaah!", "minikani_fc1", 2],
    },
    43 => { # ナマズ娘
      :actor_id => 99, :denominator => 4,
      :question => ["\\n<Catfish Girl>I don't mind traveling every now and then. Would you take me along too, young man?", "namazu_fc1", 0],
      :yes => ["\\n<Catfish Girl>Fufuu, despite my age, I'm getting excited.", "namazu_fc1", 1],
      :no => ["\\n<Catfish Girl>If there's ever a large earthquake, think of it as my anger.", "namazu_fc1", 2],
    },
    44 => { # ラフレシア娘
      :actor_id => 100, :denominator => 4,
      :question => ["\\n<Rafflesia Girl>I want to go somewhere other than the jungle every now and then. Hey, will you take me with you?", "rahure_fc1", 0],
      :yes => ["\\n<Rafflesia Girl>It's my first time leaving the jungle. I'm getting excited, fufufuu...", "rahure_fc1", 1],
      :no => ["\\n<Rafflesia Girl>Of course... Is it the smell?", "rahure_fc1", 2],
    },
    45 => { # セントール
      :actor_id => 101, :denominator => 2,
      :question => ["\\n<Centaur>Hey, take me on a trip too. I have confidence in my running.", "cent2_fc1", 0],
      :yes => ["\\n<Centaur>Fufuu, I'm your companion from now on. Get careless, and I'll take the lead.", "cent2_fc1", 1],
      :no => ["\\n<Centaur>Why the heck not?!", "cent2_fc1", 2],
    },
    46 => { # 銀狐二尾
      :actor_id => 102, :denominator => 2,
      :question => ["\\n<Two-Tailed Silver Kitsune>Hey, hey, you should make me a companion toooo! I'll show you my kitsune ninja arts!", "youko_fc1", 0],
      :yes => ["\\n<Two-Tailed Silver Kitsune>Yaaay! I'm your companion! Mufufu, I'll do my beeest!", "youko_fc1", 1],
      :no => ["\\n<Two-Tailed Silver Kitsune>Erk!", "youko_fc1", 2],
    },
    47 => { # かむろ二尾
      :actor_id => 103, :denominator => 2,
      :question => ["\\n<Two-Tailed Geisha>Um, may I accompany you? I'm inexperienced, but I will do my best.", "kamuro_fc1", 0],
      :yes => ["\\n<Two-Tailed Geisha>Th-thank you very much! I'll wholeheartedly support you with my kitsune secret arts!", "kamuro_fc1", 1],
      :no => ["\\n<Two-Tailed Geisha>I-I'm sorry...", "kamuro_fc1", 2],
    },
    48 => { # クモ娘
      :actor_id => 104, :denominator => 5,
      :question => ["\\n<Spider Girl>Fufuu, won't you make me your companion? I'll make all your obstacles my prey.", "kumo_fc1", 0],
      :yes => ["\\n<Spider Girl>Ahaa, yippee! ♪ Now I can have all I can eat♪", "kumo_fc1", 1],
      :no => ["\\n<Spider Girl>What? ...If I take this out on someone else, it'll be your fault!", "kumo_fc1", 2],
    },
    49 => { # ミミック娘
      :actor_id => 105, :denominator => 5,
      :question => ["\\n<Mimic>I'm tired of being a shut-in... Hey, will you take me on a trip too?", "mimic_fc1", 0],
      :yes => ["\\n<Mimic>My first time going to the outside world... Protect me well, okay?", "mimic_fc1", 0],
      :no => ["\\n<Mimic>Fine, I'll be a shut-in forever...", "mimic_fc1", 1],
    },
    52 => { # ナマコ娘
      :actor_id => 107, :denominator => 4,
      :question => ["\\n<Sea Cucumber Girl>Sea cucumbers sometimes want to travel the world. Hey, could you take me on an adventure too?", "namako_fc1", 0],
      :yes => ["\\n<Sea Cucumber Girl>I'll get to taste things from around the world with my sea cucumber body... Fufuu, I'm looking forward to it.", "namako_fc1", 1],
      :no => ["\\n<Sea Cucumber Girl>...Fine. I'll attack a man in revenge.", "namako_fc1", 2],
    },
    53 => { # 貝娘
      :actor_id => 108, :denominator => 4,
      :question => ["\\n<Shellfish Girl>Beloved, would you please marry me?", "kai_fc1", 0],
      :yes => ["\\n<Shellfish Girl>I'm so happy! I'll follow you anywhere, my husband♪", "kai_fc1", 1],
      :no => ["\\n<Shellfish Girl>Someday I will surely sway you into becoming my husband, you'll see...", "kai_fc1", 2],
    },
    54 => { # カニ娘
      :actor_id => 109, :denominator => 3,
      :question => ["\\n<Crab Girl>Hey, take me with you too. When you get dirty, I'll service you with plenty of bubbles♪", "kani_fc1", 0],
      :yes => ["\\n<Crab Girl>Ahahaa, I'll be in your care from now on. Please let me know when you get dirty♪", "kani_fc1", 1],
      :no => ["\\n<Crab Girl>Hmph! I hate you!", "kani_fc1", 2],
    },
    55 => { # スライムベス娘
      :actor_id => 110, :denominator => 2,
      :question => ["\\n<Slime Bess>If I follow you, will I get to eat a looot of things?", "slimelord_fc1", 4],
      :yes => ["\\n<Slime Bess>Yaaay! I'll melt and eat anythiiing♪", "slimelord_fc1", 1],
      :no => ["\\n<Slime Bess>I want to eaaat...", "slimelord_fc1", 2],
    },
    56 => { # スイカ娘
      :actor_id => 111, :denominator => 4,
      :question => ["\\n<Watermelon Girl>Hey, I want you to take me on an adventure toooo.", "suika_fc1", 0],
      :yes => ["\\n<Watermelon Girl>Yaaay, yippee! You have to stop splitting watermelons now, okay?", "suika_fc1", 1],
      :no => ["\\n<Watermelon Girl>...You don't like watermelons?", "suika_fc1", 2],
    },
    57 => { # ウツボカズラ娘
      :actor_id => 112, :denominator => 4,
      :question => ["\\n<Pitcher Plant Girl>If I go with you, I'll get to eat a lot of different prey. Hey, please take me with you.", "utubo_fc1", 0],
      :yes => ["\\n<Pitcher Plant Girl>I'm looking forward to eating insects from around the world. ...I'll eat bigger things too, of course.", "utubo_fc1", 1],
      :no => ["\\n<Pitcher Plant Girl>I'll dissolve you someday...", "utubo_fc1", 3],
    },
    58 => { # ラミア
      :actor_id => 113, :denominator => 3,
      :question => ["\\n<Lamia>I'm going to travel the world as well. Hey, you'll take me too, won't you?", "lamia_fc1", 0],
      :yes => ["\\n<Lamia>You'll feed me properly, right? ...Well then, nice to meet you.", "lamia_fc1", 1],
      :no => ["\\n<Lamia>You're pretty rude. Refusing to let ME accompany you...", "lamia_fc1", 2],
    },
    59 => { # ワカメ娘
      :actor_id => 114, :denominator => 4,
      :question => ["\\n<Seaweed Girl>Sway, sway... I want to go too...", "wakame_fc1", 0],
      :yes => ["\\n<Seaweed Girl>Even though I'm seaweed, thank you...", "wakame_fc1", 1],
      :no => ["\\n<Seaweed Girl>Sway, sway, sway...", "wakame_fc1", 2],
    },
    60 => { # クラゲ娘
      :actor_id => 115, :denominator => 4,
      :question => ["\\n<Jellyfish Girl>I also... want to adventure...", "kurage_fc1", 0],
      :yes => ["\\n<Jellyfish Girl>Traveling the world sounds fun...", "kurage_fc1", 1],
      :no => ["\\n<Jellyfish Girl>Disappointing...", "kurage_fc1", 0],
    },
    61 => { # イソギンチャク娘
      :actor_id => 116, :denominator => 4,
      :question => ["\\n<Sea Anemone Girl>Fufuu, you please me. I shall become your companion.", "iso_fc1", 0],
      :yes => ["\\n<Sea Anemone Girl>Leaving the sea for the first time... Fufuu, I'm looking forward to it.", "iso_fc1", 1],
      :no => ["\\n<Sea Anemone Girl>You don't need my strength? How humiliating...", "iso_fc1", 2],
    },
    62 => { # アンコウ娘
      :actor_id => 117, :denominator => 4,
      :question => ["\\n<Anglerfish Girl>..........", "ankou_fc1", 0],
      :yes => ["\\n<Anglerfish Girl>Nice to... meet you...", "ankou_fc1", 0],
      :no => ["\\n<Anglerfish Girl>..........", "ankou_fc1", 0],
    },
    64 => { # 17ページ
      :actor_id => 119, :denominator => 3,
      :question => ["\\n<Page 17>Let me accompany you too...", "page17_fc1", 0],
      :yes => ["\\n<Page 17>I'll be in your care from now on...", "page17_fc1", 0],
      :no => ["\\n<Page 17>Regrettable...", "page17_fc1", 0],
    },
    65 => { # 257ページ
      :actor_id => 120, :denominator => 4,
      :question => ["\\n<Page 257>Oh my, what a fine gentleman. May I accompany you as well?", "page257_fc1", 0],
      :yes => ["\\n<Page 257>Fufuu... It's a pleasure to meet you.", "page257_fc1", 1],
      :no => ["\\n<Page 257>You don't need my strength? That's disappointing...", "page257_fc1", 2],
    },
    67 => { # シスターラミア
      :actor_id => 122, :denominator => 4,
      :question => ["\\n<Sister Lamia>I see now that you are a righteous person. Would you please forgive me and allow me to travel with you?", "sisterlamia_fc1", 0],
      :yes => ["\\n<Sister Lamia>I appreciate your generous heart. Now, let us spread the teachings of the Goddess around the world.", "sisterlamia_fc1", 4],
      :no => ["\\n<Sister Lamia>It seems I was mistaken. Goddess, please let me meet some kind people.", "sisterlamia_fc1", 3],
    },
    68 => { # シスキュバス
      :actor_id => 123, :denominator => 4,
      :question => ["\\n<Succubus Nun>It just so happens that I'm also traveling the world. Would you like to travel together?", "sisccubus_fc1", 0],
      :yes => ["\\n<Succubus Nun>That's very reassuring. Please use my power to its fullest.", "sisccubus_fc1", 1],
      :no => ["\\n<Succubus Nun>Are our paths not intertwined? How disappointing...", "sisccubus_fc1", 2],
    },
    69 => { # アリクイ娘
      :actor_id => 124, :denominator => 4,
      :question => ["\\n<Anteater Girl>Even though I'm not good at combat, could you take me with you? I'm sure my long tongue will be useful...", "arikui_fc1", 0],
      :yes => ["\\n<Anteater Girl>I'll do my best, so don't abandon me.", "arikui_fc1", 1],
      :no => ["\\n<Anteater Girl>So I'm useless after all...", "arikui_fc1", 2],
    },
    70 => { # グリズリー娘
      :actor_id => 125, :denominator => 3,
      :question => ["\\n<Grizzly Bear Girl>Roaaar! I want to go with you!", "grizzly_fc1", 0],
      :yes => ["\\n<Grizzly Bear Girl>Roaaar! Let's gooo!", "grizzly_fc1", 1],
      :no => ["\\n<Grizzly Bear Girl>Rawr... You meanie...", "grizzly_fc1", 2],
    },
    71 => { # XX-7
      :actor_id => 126, :denominator => 4,
      :question => ["\\n<XX-7>May I accompany you?", "XX-7_fc1", 0],
      :yes => ["\\n<XX-7>In that case, I will obey.", "XX-7_fc1", 0],
      :no => ["\\n<XX-7>Disappointing...", "XX-7_fc1", 0],
    },
    72 => { # リトルバグ
      :actor_id => 127, :denominator => 4,
      :question => ["\\n<Little Bug>Hey! Take me too!", "littlebug_fc1", 0],
      :yes => ["\\n<Little Bug>Yippee! Now I can get out of here!", "littlebug_fc1", 0],
      :no => ["\\n<Little Bug>Am I gonna be stuck here forever...?", "littlebug_fc1", 2],
    },
    73 => { # キャンサーロイド
      :actor_id => 128, :denominator => 5,
      :question => ["\\n<Canceroid>Human, please take me outside. I promise to work hard.", "kaniloid_fc1", 0],
      :yes => ["\\n<Canceroid>Thank you. Let me prove my capability.", "kaniloid_fc1", 1],
      :no => ["\\n<Canceroid>How narrow-minded...", "kaniloid_fc1", 2],
    },
    75 => { # ゴースト
      :actor_id => 130, :denominator => 3,
      :question => ["\\n<Ghost Girl>Me too... Take me with you...", "ghost_fc1", 0],
      :yes => ["\\n<Ghost Girl>Even though I'm a ghost, it's nice to meet you...", "ghost_fc1", 1],
      :no => ["\\n<Ghost Girl>Ohhh, now I have a grudge...", "ghost_fc1", 0],
    },
    76 => { # 呪いの人形娘
      :actor_id => 131, :denominator => 3,
      :question => ["\\n<Cursed Doll>Big brother... I want to play more...", "doll_fc1", 0],
      :yes => ["\\n<Cursed Doll>Ufufuu, we'll be together forever...", "doll_fc1", 1],
      :no => ["\\n<Cursed Doll>I want to play... I want to play...", "doll_fc1", 2],
    },
    77 => { # ゾンビ剣士
      :actor_id => 132, :denominator => 3,
      :question => ["\\n<Zombie Swordsman>I also... want to go...", "zonbe_fc2", 0],
      :yes => ["\\n<Zombie Swordsman>This sword... is yours.", "zonbe_fc2", 0],
      :no => ["\\n<Zombie Swordsman>This sword will just rust away in here...", "zonbe_fc2", 0],
    },
    78 => { # ゾンビ娘
      :actor_id => 133, :denominator => 4,
      :question => ["\\n<Zombie Girl>Ohh... Take us... with you...", "zonbe_fc3", 0],
      :yes => ["\\n<Zombie Girl>Let's go... together...", "zonbe_fc3", 0],
      :no => ["\\n<Zombie Girl>..........", "zonbe_fc3", 2],
    },
    84 => { # エルフ
      :actor_id => 136, :denominator => 3,
      :question => ["\\n<Elf>You look like you could use some help. Shall I accompany you on your travels?", "elf_fc1", 0],
      :yes => ["\\n<Elf>I thought as much. Well then, I shall protect you with my bow!", "elf_fc1", 1],
      :no => ["\\n<Elf>...Hmph. It doesn't matter to me either way.", "elf_fc1", 2],
    },
    85 => { # ブラウニーズ
      :actor_id => 137, :denominator => 4,
      :question => ["\\n<Brownies>Hey, big bro, let's be friends♪", "braunys_fc1", 6],
      :yes => ["\\n<Brownies>Yaaay! Let's play together♪", "braunys_fc1", 7],
      :no => ["\\n<Brownies>We want to be friends...", "braunys_fc2", 0],
    },
    86 => { # ツインズフェアリー
      :actor_id => 138, :denominator => 4,
      :question => ["\\n<Twin Fairies>Hey, we want you to take us too. We'll protect you with fairy power!", "tfairy_fc1", 0],
      :yes => ["\\n<Twin Fairies>Even we can be helpful! We'll show you the power of fairies!", "tfairy_fc1", 1],
      :no => ["\\n<Twin Fairies>Even if we are fairies... we can be usefulll...", "tfairy_fc1", 2],
    },
    87 => { # フェアリーズ
      :actor_id => 139, :denominator => 4,
      :question => ["\\n<Fairies>Hey, hey, let's be friends♪", "fairys_fc1", 0],
      :yes => ["\\n<Fairies>Yaaay! Everyone! This guy is gonna play with us!", "fairys_fc1", 0],
      :no => ["\\n<Fairies>Meanieee! Meanieee!", "fairys_fc1", 2],
    },
    95 => { # タランチュラ娘
      :actor_id => 140, :denominator => 4,
      :question => ["\\n<Tarantula Girl>Hey, can I come with you too? I'm pretty confident when it comes to battle...", "taran_fc1", 0],
      :yes => ["\\n<Tarantula Girl>I'll be in your care from now on. I'll do my best.", "taran_fc1", 1],
      :no => ["\\n<Tarantula Girl>Do you dislike women with a spider for their lower half?", "taran_fc1", 2],
    },
    96 => { # ミノタウロス娘
      :actor_id => 141, :denominator => 3,
      :question => ["\\n<Minotauros>You're pretty strong, despite your appearance. Hey, take me with you too!", "mino_fc1", 1],
      :yes => ["\\n<Minotauros>I burn a lot of energy, so I'll be depending on you for meals!", "mino_fc1", 0],
      :no => ["\\n<Minotauros>Hey, hey, you're bullshitting me, right?!", "mino_fc1", 2],
    },
    97 => { # バンダースナッチ娘
      :actor_id => 142, :denominator => 4,
      :question => ["\\n<Bandersnatch Girl>You're strong... I'll go with you too...", "bander_fc1", 0],
      :yes => ["\\n<Bandersnatch Girl>I'll defeat all of your enemies...", "bander_fc1", 0],
      :no => ["\\n<Bandersnatch Girl>I see... That's unfortunate...", "bander_fc1", 2],
    },
    99 => { # サボレス
      :actor_id => 144, :denominator => 3,
      :question => ["\\n<Sables>Hey, will you make me part of your crew as well?", "saboresu_fc1", 0],
      :yes => ["\\n<Sables>Ahahaa, nice to meet youuu!", "saboresu_fc1", 1],
      :no => ["\\n<Sables>Whaaat?! Meanieee!", "saboresu_fc1", 2],
    },
    100 => { # ムカデ娘
      :actor_id => 145, :denominator => 4,
      :question => ["\\n<Centipede Girl>...Do you want to take me on your adventure?", "mukade_fc1", 0],
      :yes => ["\\n<Centipede Girl>I will show you that centipedes can be more than just unlikeable.", "mukade_fc1", 1],
      :no => ["\\n<Centipede Girl>Well, I am a centipede, something that is despised...", "mukade_fc1", 2],
    },
    101 => { # サソリ娘
      :actor_id => 146, :denominator => 3,
      :question => ["\\n<Scorpion Girl>I'm bored of the desert. Could you take me somewhere else?", "sasori_fc1", 0],
      :yes => ["\\n<Scorpion Girl>I'm quite strong, even in places other than the desert. Fufuu, nice to meet you.", "sasori_fc1", 1],
      :no => ["\\n<Scorpion Girl>Fine, I'll live in the desert forever.", "sasori_fc1", 2],
    },
    102 => { # サボテン娘
      :actor_id => 147, :denominator => 4,
      :question => ["\\n<Cactus Girl>Ufufuu, you're quite the gentleman. Will you have me by your side?", "saboten_fc1", 0],
      :yes => ["\\n<Cactus Girl>Let your enemies know that even a beautiful cactus still has thorns.", "saboten_fc1", 1],
      :no => ["\\n<Cactus Girl>Such humiliation... Someday I shall return the favor with all of my thorns.", "saboten_fc1", 2],
    },
    103 => { # ダチョウ娘
      :actor_id => 148, :denominator => 3,
      :question => ["\\n<Ostrich Girl>Hey, hey, take me with you too! I can't fly, but I can run really fast!", "datyou_fc1", 0],
      :yes => ["\\n<Ostrich Girl>Yaaay! I'll give it all I've got!", "datyou_fc1", 3],
      :no => ["\\n<Ostrich Girl>I knew it. So it's no good if I can't fly, is it?", "datyou_fc1", 2],
    },
    104 => { # ランプの魔女
      :actor_id => 149, :denominator => 4,
      :question => ["\\n<Lamp Genie>Will you listen to my wish? I would like to be one of your attendants.", "lamp_fc1", 0],
      :yes => ["\\n<Lamp Genie>Fufuu, I'll never leave your side. My power is yours to use.", "lamp_fc1", 1],
      :no => ["\\n<Lamp Genie>You don't want my power? Well then, I will quietly take my leave.", "lamp_fc1", 2],
    },
    105 => { # ミイラ娘
      :actor_id => 150, :denominator => 3,
      :question => ["\\n<Mummy Girl>Hero, release me from this pyramid...", "mummy_fc1", 0],
      :yes => ["\\n<Mummy Girl>Let's go together, hero...", "mummy_fc1", 1],
      :no => ["\\n<Mummy Girl>You don't need my power...?", "mummy_fc1", 2],
    },
    106 => { # コブラ娘
      :actor_id => 151, :denominator => 4,
      :question => ["\\n<Cobra Girl>You're strong... Could you take me along as well?", "kobura_fc1", 0],
      :yes => ["\\n<Cobra Girl>I wonder what kind of vast world lies beyond the desert? Fufuu, I can't wait.", "kobura_fc1", 1],
      :no => ["\\n<Cobra Girl>Is it because this dry place really suits me?", "kobura_fc1", 2],
    },
    107 => { # ネフェルラミアス
      :actor_id => 152, :denominator => 4,
      :question => ["\\n<Nefertiti Lamias>You're pretty nice. Would you take care of us sisters?", "lamias_fc2", 4],
      :yes => ["\\n<Nefertiti Lamias>The four of us will be your strength. So, you as well... Can you guess?", "lamias_fc2", 4],
      :no => ["\\n<Nefertiti Lamias>Hmph, you're an unreliable man...", "lamias_fc2", 4],
    },
    111 => { # ワニ娘
      :actor_id => 154, :denominator => 4,
      :question => ["\\n<Alligator Girl>Hey, can I be your companion too?", "wani_fc1", 0],
      :yes => ["\\n<Alligator Girl>Well then, nice to meet you.", "wani_fc1", 1],
      :no => ["\\n<Alligator Girl>That's unfortunate... Well, maybe next time.", "wani_fc1", 2],
    },
    113 => { # デビルファイター
      :actor_id => 156, :denominator => 3,
      :question => ["\\n<Devil Fighter>Will you take me on your adventure too? I may be dressed embarrassingly, but I am strong, ok?", "d_fighter_fc1", 0],
      :yes => ["\\n<Devil Fighter>Well then, I'll be in your care from now on. ...If I can, I would also like to change my clothes.", "d_fighter_fc1", 1],
      :no => ["\\n<Devil Fighter>I-is that so... Well then, goodbye.", "d_fighter_fc1", 0],
    },
    114 => { # 大蜘蛛
      :actor_id => 157, :denominator => 4,
      :question => ["\\n<Oogumo>Hey, can I tag along with you?", "oogumo_fc1", 0],
      :yes => ["\\n<Oogumo>I'm gonna be someone you can all depend on! I'm pretty strong, you know.", "oogumo_fc1", 1],
      :no => ["\\n<Oogumo>Hmph. Do what you want!", "oogumo_fc1", 2],
    },
    115 => { # サックボア
      :actor_id => 158, :denominator => 4,
      :question => ["\\n<Suck Vore>...........", "suckvore_fc1", 2],
      :yes => ["\\n<Suck Vore>...........", "suckvore_fc1", 2],
      :no => ["\\n<Suck Vore>...........", "suckvore_fc1", 2],
    },
    116 => { # アイアンメイデン
      :actor_id => 159, :denominator => 5,
      :question => ["\\n<Iron Maiden>...........", "ironmaiden_fc1", 0],
      :yes => ["\\n<Iron Maiden>...........", "ironmaiden_fc1", 1],
      :no => ["\\n<Iron Maiden>...........", "ironmaiden_fc1", 0],
    },
    117 => { # ワームビレッジャ
      :actor_id => 160, :denominator => 4,
      :question => ["\\n<Worm Villager>...I want to suck more. Take me too.", "wormv_fc1", 0],
      :yes => ["\\n<Worm Villager>I get to suck more... More, more...", "wormv_fc1", 1],
      :no => ["\\n<Worm Villager>That's disappointing. I want to suck more...", "wormv_fc1", 2],
    },
    118 => { # ウーストレル
      :actor_id => 161, :denominator => 4,
      :question => ["\\n<Ustrel>Ufufuu, will you take me as well? Traveling around the world sounds quite interesting.", "ustrel_fc1", 0],
      :yes => ["\\n<Ustrel>I'm looking forward to it. Fufufuu...", "ustrel_fc1", 1],
      :no => ["\\n<Ustrel>So that method doesn't work...", "ustrel_fc1", 2],
    },
    119 => { # 蜜壺
      :actor_id => 162, :denominator => 5,
      :question => ["\\n<Honey Pot>Hey, please take me on your adventure too. But I'm not going to leave my pot, of course.", "mitutubo_fc1", 0],
      :yes => ["\\n<Honey Pot>Traveling the world in my pot... That's fun too, right?", "mitutubo_fc1", 1],
      :no => ["\\n<Honey Pot>I hate you...", "mitutubo_fc1", 2],
    },
    121 => { # 小鬼
      :actor_id => 164, :denominator => 3,
      :question => ["\\n<Oni>Hey, can I come with you too? You can count on my strength!", "kooni_fc1", 0],
      :yes => ["\\n<Oni>Yippee! Nice to meet you! I'll crush all the bad guys with my club!", "kooni_fc1", 1],
      :no => ["\\n<Oni>Fine, I can travel as much as I want alone too!", "kooni_fc1", 3],
    },
    122 => { # オナホ娘
      :actor_id => 165, :denominator => 4,
      :question => ["\\n<Onahole Girl>May I stick with you as well? I'll be really useful when you've stored up a bunch♪", "onaho_fc1", 0],
      :yes => ["\\n<Onahole Girl>Ahaa, pleased to meet you♪\nLet me know whenever you've built up some♪", "onaho_fc1", 0],
      :no => ["\\n<Onahole Girl>Do you have some principles against perverted tools?", "onaho_fc1", 2],
    },
    123 => { # ナーキュバス
      :actor_id => 166, :denominator => 4,
      :question => ["\\n<Naccubus>Geez, you're such a troublesome patient... Should I give you my full-time care?", "narcubus_fc1", 0],
      :yes => ["\\n<Naccubus>Well then, it's a pleasure to meet you. If anything happens, you can depend on me♪", "narcubus_fc1", 3],
      :no => ["\\n<Naccubus>Geez, you need to listen to your nurse...", "narcubus_fc1", 2],
    },
    125 => { # 百々目鬼
      :actor_id => 168, :denominator => 4,
      :question => ["\\n<Dodomeki>You're pretty interesting... I'll lend you my power as well.", "dodome_fc1", 0],
      :yes => ["\\n<Dodomeki>Well then, I'll assist you. I hope you like the magical power of these eyes.", "dodome_fc1", 1],
      :no => ["\\n<Dodomeki>Hmph! I'm not upset!", "dodome_fc1", 2],
    },
    126 => { # リザードシーフ
      :actor_id => 169, :denominator => 3,
      :question => ["\\n<Lizard Thief>I really like you. Hey, can I join your group too?", "lizardthief_fc1", 0],
      :yes => ["\\n<Lizard Thief>Okay, starting today I'm also a member of your gang! I'll be in your care from now on!", "lizardthief_fc1", 0],
      :no => ["\\n<Lizard Thief>Is it because I'm not strong enough? Then I'll ask again once I get stronger!", "lizardthief_fc1", 2],
    },
    127 => { # リザードシーフ
      :actor_id => 170, :denominator => 4,
      :question => ["\\n<Lizard Thief>You seem to be quite skilled... May I accompany you as well?", "lizardthief_fc2", 0],
      :yes => ["\\n<Lizard Thief>Fufuu... Please take care of me from now on. If you need a sword or a thief, leave it to me.", "lizardthief_fc2", 0],
      :no => ["\\n<Lizard Thief>Oh, that's unfortunate...", "lizardthief_fc2", 2],
    },
    129 => { # 蜃気楼娘
      :actor_id => 172, :denominator => 4,
      :question => ["\\n<Mirage Girl>Hey, could you take me with you too, please?", "sinkiro_fc1", 0],
      :yes => ["\\n<Mirage Girl>Yaaay! I'll do my beeest!", "sinkiro_fc1", 4],
      :no => ["\\n<Mirage Girl>Waaah! Meaniiie!", "sinkiro_fc1", 3],
    },
    130 => { # アリジゴク娘
      :actor_id => 173, :denominator => 4,
      :question => ["\\n<Antlion Girl>If I'm with you, I'll probably get a lot of prey. You could be the best bait of all...", "arizigoku_fc1", 0],
      :yes => ["\\n<Antlion Girl>Fufuu... I'll have my pick of all the prey I can squeeze. Of course, I'll save you for last.", "arizigoku_fc1", 1],
      :no => ["\\n<Antlion Girl>Oh... Nothing good comes from talking...", "arizigoku_fc1", 2],
    },
    131 => { # サンドワーム娘
      :actor_id => 174, :denominator => 5,
      :question => ["\\n<Sandworm>With you... I want to go...", "sandw_fc1", 0],
      :yes => ["\\n<Sandworm>Nice to meet you...", "sandw_fc1", 1],
      :no => ["\\n<Sandworm>Am I too big...?", "sandw_fc1", 2],
    },
    132 => { # デザートスキュラ
      :actor_id => 175, :denominator => 4,
      :question => ["\\n<Desert Scylla>Ahahaa, may I go with you as well?", "d_scylla_fc1", 0],
      :yes => ["\\n<Desert Scylla>Well then, nice to meet youuu♪", "d_scylla_fc1", 1],
      :no => ["\\n<Desert Scylla>What? How booorrriiing.", "d_scylla_fc1", 2],
    },
    134 => { # ヴィタエ
      :actor_id => 176, :denominator => 5,
      :question => ["\\n<Vitae>I'm tired of this place. Won't you please invite me to go to the outside world?", "vitae_fc1", 0],
      :yes => ["\\n<Vitae>I'm really looking forward to it. What's waiting for me out there?", "vitae_fc1", 1],
      :no => ["\\n<Vitae>Oh my, how unfortunate...", "vitae_fc1", 2],
    },
    135 => { # ヴェータラ
      :actor_id => 177, :denominator => 5,
      :question => ["\\n<Vetala>Rejoice, boy. Big sister will be your companion.", "vetala_fc1", 0],
      :yes => ["\\n<Vetala>Now I probably won't go hungry for a while. Ufufuu, does the boy want to be eaten too?", "vetala_fc1", 1],
      :no => ["\\n<Vetala>Oh? Do you want me to eat you that much?", "vetala_fc1", 2],
    },
    136 => { # ヴァルト
      :actor_id => 178, :denominator => 5,
      :question => ["\\n<Valto>Requesting permission to accompany you.", "valt_fc1", 0],
      :yes => ["\\n<Valto>Affirmative. I will accompany master from now on.", "valt_fc1", 0],
      :no => ["\\n<Valto>Rejected...", "valt_fc1", 2],
    },
    137 => { # シニファ
      :actor_id => 179, :denominator => 5,
      :question => ["\\n<Shinifa>AaHAHAHAHAHAHA!", "sinifa_fc1", 0],
      :yes => ["\\n<Shinifa>HyaHAHAHAHAHAHA!", "sinifa_fc1", 1],
      :no => ["\\n<Shinifa>AHAHA...", "sinifa_fc1", 2],
    },
    138 => { # シャドー娘
      :actor_id => 180, :denominator => 4,
      :question => ["\\n<Shadow Girl>Take... me...", "shadow_fc1", 0],
      :yes => ["\\n<Shadow Girl>I shall possess you...", "shadow_fc1", 0],
      :no => ["\\n<Shadow Girl>Bitter... disappointment...", "shadow_fc1", 0],
    },
    139 => { # ガイストビーネ
      :actor_id => 181, :denominator => 4,
      :question => ["\\n<Paintgeist>I wonder if this world is more vast than the one in my painting? Hey, will you take me outside?", "gaistvine_fc1", 0],
      :yes => ["\\n<Paintgeist>Well then, let's go on an adventure.", "gaistvine_fc1", 0],
      :no => ["\\n<Paintgeist>Hmph... The one in this painting is great anyway.", "gaistvine_fc1", 1],
    },
    140 => { # キメラホムンクルス
      :actor_id => 182, :denominator => 4,
      :question => ["\\n<Chimera Homunculus>I want to learn the meaning behind my existence... Will I learn it if I go with you...?", "c_homunculus_fc1", 0],
      :yes => ["\\n<Chimera Homunculus>I shall accompany you...", "c_homunculus_fc1", 1],
      :no => ["\\n<Chimera Homunculus>You are... useless...", "c_homunculus_fc1", 2],
    },
    141 => { # アイアンメイデン改
      :actor_id => 183, :denominator => 5,
      :question => ["\\n<Neo Iron Maiden>I will go too... so that I may squeeze sinners...", "ironmaiden_k_fc1", 0],
      :yes => ["\\n<Neo Iron Maiden>Your enemies... Sinners... I will squeeze them all...", "ironmaiden_k_fc1", 1],
      :no => ["\\n<Neo Iron Maiden>You too... are a sinner...", "ironmaiden_k_fc1", 2],
    },
    142 => { # ジャンクドール娘
      :actor_id => 184, :denominator => 5,
      :question => ["\\n<Junk Doll Girl>Will you take us along? Don't worry, we'll behave...", "junkdoll_fc2", 0],
      :yes => ["\\n<Junk Doll Girl>Thank you. Fufufufuu... I'll turn all of your enemies into junk.", "junkdoll_fc2", 0],
      :no => ["\\n<Junk Doll Girl>You don't need us? Is it because we're junk?", "junkdoll_fc2", 0],
    },
    151 => { # きのこ娘
      :actor_id => 191, :denominator => 4,
      :question => ["\\n<Mushroom Girl>Oh my, what a nice man.\nWould you take me away from here?", "kinoko_fc1", 0],
      :yes => ["\\n<Mushroom Girl>I'll be doing my best for your sake from now on. Fufufu...", "kinoko_fc1", 0],
      :no => ["\\n<Mushroom Girl>You're so unkind...", "kinoko_fc1", 2],
    },
    152 => { # ノビスタドール娘
      :actor_id => 192, :denominator => 4,
      :question => ["\\n<Novistador Girl>Give me food! Food!", "nobisutam_fc1", 0],
      :yes => ["\\n<Novistador Girl>Food, please!", "nobisutam_fc1", 0],
      :no => ["\\n<Novistador Girl>Food...", "nobisutam_fc1", 2],
    },
    153 => { # ウルスキュラ
      :actor_id => 193, :denominator => 4,
      :question => ["\\n<Urscylla>Hey, can you take me along as your ally too?", "u_scylla_fc1", 0],
      :yes => ["\\n<Urscylla>All right, we're allies from now on!", "u_scylla_fc1", 0],
      :no => ["\\n<Urscylla>I see... That's too bad...", "u_scylla_fc1", 2],
    },
    154 => { # 襖
      :actor_id => 194, :denominator => 5,
      :question => ["\\n<Fusuma>Hey, can I come along too?", "husuma_fc1", 0],
      :yes => ["\\n<Fusuma>All right, let's work together.", "husuma_fc1", 0],
      :no => ["\\n<Fusuma>How boring...", "husuma_fc1", 2],
    },
    155 => { # マーメイド
      :actor_id => 195, :denominator => 3,
      :question => ["\\n<Mermaid>Hey, take me along too.\nMy healing and water abilities are pretty useful, you know.", "mermaid_fc1", 0],
      :yes => ["\\n<Mermaid>Fufu... We're allies now, then.\nNice to meet you, Mr. Human.", "mermaid_fc1", 0],
      :no => ["\\n<Mermaid>Oh, too bad... You have enough healing, then?", "mermaid_fc1", 2],
    },
    156 => { # 商人マーメイド
      :actor_id => 196, :denominator => 4,
      :question => ["\\n<Mermaid Merchant>Hey, take me with you!\nIt's always been my dream to do business around the world!", "s_mermaid_fc1", 0],
      :yes => ["\\n<Mermaid Merchant>All right, nice to meet ya!\nI'll work my hardest!", "s_mermaid_fc1", 0],
      :no => ["\\n<Mermaid Merchant>Wow, you're so narrow-minded...", "s_mermaid_fc1", 2],
    },
    157 => { # 海賊マーメイド
      :actor_id => 197, :denominator => 2,
      :question => ["\\n<Mermaid Pirate>Do you wanna hire me?\nIf you do, you'll flourish.", "k_mermaid_fc1", 0],
      :yes => ["\\n<Mermaid Pirate>Fufu, good choice.\nWith my help, your success is guaranteed!", "k_mermaid_fc1", 0],
      :no => ["\\n<Mermaid Pirate>Hmph. I see you don't have an eye for quality!", "k_mermaid_fc1", 2],
    },
    158 => { # 一反木綿娘
      :actor_id => 198, :denominator => 5,
      :question => ["\\n<Ittan-Momen>Yaay! I'll follow you too!", "ittanmomen_fc1", 0],
      :yes => ["\\n<Ittan-Momen>Yaay! I'll stick with you!", "ittanmomen_fc1", 0],
      :no => ["\\n<Ittan-Momen>Horrible! Awful!", "ittanmomen_fc1", 2],
    },
    161 => { # ダゴン娘
      :actor_id => 199, :denominator => 4,
      :question => ["\\n<Dagon Girl>Umm... Would you please take me with you?", "dagon_fc1", 0],
      :yes => ["\\n<Dagon Girl>All right, let's work together, then♪", "dagon_fc1", 0],
      :no => ["\\n<Dagon Girl>Too bad...", "dagon_fc1", 2],
    },
    162 => { # 人魂娘
      :actor_id => 200, :denominator => 4,
      :question => ["\\n<Hitodama Girl>Hey, hey, make me your friend too!", "hitodama_fc1", 0],
      :yes => ["\\n<Hitodama Girl>I may only be a soul, but it's nice to meet ya!", "hitodama_fc1", 0],
      :no => ["\\n<Hitodama Girl>I'll curse you...", "hitodama_fc1", 2],
    },
    168 => { # カエル娘
      :actor_id => 206, :denominator => 4,
      :question => ["\\n<Frog Girl>Hey, make me your friend too.\nDespite how I look, I can fight, you know.", "kaeru_fc1", 0],
      :yes => ["\\n<Frog Girl>Aha, we'll work well together♪", "kaeru_fc1", 0],
      :no => ["\\n<Frog Girl>Ribbit, ribbit...", "kaeru_fc1", 2],
    },
    170 => { # ケンタウロス娘
      :actor_id => 207, :denominator => 4,
      :question => ["\\n<Kentauros>Just for you, I'll be your ally.\nMy powerful legs will come in handy for sure.", "centa_fc1", 0],
      :yes => ["\\n<Kentauros>Well, let's not be slow, then!", "centa_fc1", 0],
      :no => ["\\n<Kentauros>...If that's your choice. I don't care...", "centa_fc1", 2],
    },
    171 => { # アルラウネ
      :actor_id => 208, :denominator => 2,
      :question => ["\\n<Alraune>Howahowaaa...\nCan I follow you?", "alraune_fc1", 0],
      :yes => ["\\n<Alraune>Yaay! Thank you so much! ♪", "alraune_fc1", 0],
      :no => ["\\n<Alraune>Too bad...", "alraune_fc1", 1],
    },
    172 => { # 御菊蟲
      :actor_id => 209, :denominator => 4,
      :question => ["\\n<Okiku-Mushi>You should take me along, big bro.\nI'm bored of this place...", "okikumusi_fc1", 0],
      :yes => ["\\n<Okiku-Mushi>Yay! Where will you take me? ♪", "okikumusi_fc1", 0],
      :no => ["\\n<Okiku-Mushi>Meanie...", "okikumusi_fc1", 2],
    },
    173 => { # 幽霊娘
      :actor_id => 210, :denominator => 4,
      :question => ["\\n<Spirit Girl>Bring me along...\nI'll curse your enemies...", "ghost2_fc1", 0],
      :yes => ["\\n<Spirit Girl>I'll always be by your side...", "ghost2_fc1", 1],
      :no => ["\\n<Spirit Girl>I'll... Curse you...", "ghost2_fc1", 2],
    },
    174 => { # ハコイリ
      :actor_id => 211, :denominator => 5,
      :question => ["\\n<Boxed Girl>There's somewhere I want to go too.\nWill you escort me?", "hakoiri_fc1", 0],
      :yes => ["\\n<Boxed Girl>Well then, let's go somewhere fun.\nI'm in your care♪", "hakoiri_fc1", 0],
      :no => ["\\n<Boxed Girl>It's awful to refuse a lady's request...", "hakoiri_fc1", 2],
    },
    179 => { # 濡れ女
      :actor_id => 214, :denominator => 4,
      :question => ["\\n<Nure-Onna>You're interesting.\nWon't you make me your ally?", "nureonnna_fc1", 0],
      :yes => ["\\n<Nure-Onna>Fufufu, good answer.\nVery well, I'll go with you.", "nureonnna_fc1", 0],
      :no => ["\\n<Nure-Onna>Hmph. I guess I'm not good enough for you...", "nureonnna_fc1", 2],
    },
    180 => { # ハイミノタウロス
      :actor_id => 215, :denominator => 3,
      :question => ["\\n<High Minotauros>Fufu, such a lively traveler.\nShall I lend you a hand?", "h_mino_fc1", 0],
      :yes => ["\\n<High Minotauros>Fufu... Nice to meet you.\nI may look soft, but I'm really strong♪", "h_mino_fc1", 3],
      :no => ["\\n<High Minotauros>Don't push yourself too hard...", "h_mino_fc1", 1],
    },
    181 => { # ミズタウロス
      :actor_id => 216, :denominator => 4,
      :question => ["\\n<Misstauros>Ara Ara, such an energetic boy...\nShall I also lend you a hand?", "m_mino_fc1", 0],
      :yes => ["\\n<Misstauros>Let's be allies, then.\nWhen you're in trouble, rely on me.", "m_mino_fc1", 0],
      :no => ["\\n<Misstauros>...Are you really okay with that?", "m_mino_fc1", 2],
    },
    182 => { # ジニタウロス
      :actor_id => 217, :denominator => 4,
      :question => ["\\n<Genitauros>Damn, you're pretty good.\nMind if I join you?", "zinitauros_fc1", 0],
      :yes => ["\\n<Genitauros>I'm quite a dexterous member of the Minotauros tribe.\nI may not be as powerful, but you can count on me!", "zinitauros_fc1", 0],
      :no => ["\\n<Genitauros>Is it because I don't have enough muscles?", "zinitauros_fc1", 2],
    },
    185 => { # くのいちエルフ
      :actor_id => 219, :denominator => 4,
      :question => ["\\n<Kunoichi Elf>Take me along on your adventure.\nI'll continue my training journey with you.", "kunoitielf_fc1", 0],
      :yes => ["\\n<Kunoichi Elf>I'm your comrade now.\nLet's try my Ninjutsu in every country!", "kunoitielf_fc1", 0],
      :no => ["\\n<Kunoichi Elf>Is my Ninjutsu unnecessary?\nWhat a depressing notion...", "kunoitielf_fc1", 2],
    },
    186 => { # サムライエルフ
      :actor_id => 220, :denominator => 4,
      :question => ["\\n<Samurai Elf>Oho, aren't you something...\nIt'd be good practice to go along with you.", "samuraielf_fc1", 0],
      :yes => ["\\n<Samurai Elf>Very good.\nLet's continue together.", "samuraielf_fc1", 0],
      :no => ["\\n<Samurai Elf>I see. How unfortunate.", "samuraielf_fc1", 2],
    },
    187 => { # 雪女
      :actor_id => 221, :denominator => 3,
      :question => ["\\n<Yuki-Onna>I'll let you invite me to your party.\nBut you mustn't tell anyone about tonight...", "yukionna_fc1", 0],
      :yes => ["\\n<Yuki-Onna>Well then, I'll go with you.\nJust make sure you keep your promise.", "yukionna_fc1", 0],
      :no => ["\\n<Yuki-Onna>I see... That's all right...", "yukionna_fc1", 2],
    },
    188 => { # ねこまた
      :actor_id => 222, :denominator => 2,
      :question => ["\\n<Nekomata>Unyaa! Nyaa! Nyaanyaa!", "nekomata_fc1", 2],
      :yes => ["\\n<Nekomata>Nyaa! Nyaa! Nyaa!", "nekomata_fc1", 2],
      :no => ["\\n<Nekomata>Fssss!", "nekomata_fc1", 1],
    },
    189 => { # あかなめ
      :actor_id => 223, :denominator => 3,
      :question => ["\\n<Akaname>Hey, take us along.\nYou're traveling the world, aren't you?", "akaname_fc2", 1],
      :yes => ["\\n<Akaname>So exciting! Traveling the world!\nLet's get going right now!", "akaname_fc2", 2],
      :no => ["\\n<Akaname>We just wanted to lick the whole world...\nIt's no fair taking it all for yourself...", "akaname_fc2", 3],
    },
    190 => { # 河童
      :actor_id => 224, :denominator => 3,
      :question => ["\\n<Kappa>Kapapa!\nHey, bring me along too!", "kappa_fc1", 0],
      :yes => ["\\n<Kappa>Kapapa!\nNice to meet ya!", "kappa_fc1", 0],
      :no => ["\\n<Kappa>Kapapa...", "kappa_fc1", 2],
    },
    191 => { # 二口娘
      :actor_id => 225, :denominator => 3,
      :question => ["\\n<Futakuchi Girl>Um, I'd also like to travel the world...\nI'm sure there are lots of tasty things out there, right...?", "hutakuti_fc1", 5],
      :yes => ["\\n<Futakuchi Girl>Thank you so much!\nI'm already hungry...", "hutakuti_fc1", 5],
      :no => ["\\n<Futakuchi Girl>Hauu... I'm so hungry...\nI've been left behind again...", "hutakuti_fc1", 7],
    },
    193 => { # 巫女ラミア
      :actor_id => 227, :denominator => 4,
      :question => ["\\n<Miko Lamia>Do you want a miko as an ally?\nI may be young, but I'm quite skilled.", "mikolamia_fc1", 0],
      :yes => ["\\n<Miko Lamia>All right, I'll go with you.\nMy dances will bring you victory.", "mikolamia_fc1", 0],
      :no => ["\\n<Miko Lamia>I see...\nAt the very least, I shall pray for you on your journey.", "mikolamia_fc1", 2],
    },
    194 => { # 巫女アラクネ
      :actor_id => 228, :denominator => 4,
      :question => ["\\n<Miko Arachne>Take me along too.\nI'm sure my strength will be useful.", "mikoarachne_fc1", 0],
      :yes => ["\\n<Miko Arachne>I'm good with time magic.\nNice to meet you♪", "mikoarachne_fc1", 1],
      :no => ["\\n<Miko Arachne>I see.\nHumans truly do hate spiders...", "mikoarachne_fc1", 3],
    },
    195 => { # 毛倡妓
      :actor_id => 229, :denominator => 4,
      :question => ["\\n<Kejourou>Just for you, I'll help out.\nI'll go with you, so be grateful.", "kezyorou_fc1", 0],
      :yes => ["\\n<Kejourou>Fufu... I'm looking forward to this.\nIt's my first time leaving Yamatai.", "kezyorou_fc1", 0],
      :no => ["\\n<Kejourou>I see... You're a boring boy, you know that?", "kezyorou_fc1", 2],
    },
    197 => { # マジカルアゲハ
      :actor_id => 231, :denominator => 5,
      :question => ["\\n<Magical Butterfly>Hey, I want to go with you tooooo! ♪", "m_batterfly_fc1", 0],
      :yes => ["\\n<Magical Butterfly>Yaay, nice to meet yooou! ♪", "m_batterfly_fc1", 0],
      :no => ["\\n<Magical Butterfly>Meanie...", "m_batterfly_fc1", 2],
    },
    200 => { # マジカルピクシー
      :actor_id => 232, :denominator => 5,
      :question => ["\\n<Magical Pixie>Hey, can I be your ally too?\nI can help out with my magic.", "m_fairy_fc1", 0],
      :yes => ["\\n<Magical Pixie>Get a good look at my magic!\nI'll crush any enemy!", "m_fairy_fc1", 0],
      :no => ["\\n<Magical Pixie>You have awful judgement! Geez!", "m_fairy_fc1", 2],
    },
    204 => { # カマキリ娘
      :actor_id => 234, :denominator => 4,
      :question => ["\\n<Mantis Girl>Heehee... Come with?", "kamakiri_fc1", 0],
      :yes => ["\\n<Mantis Girl>Enemy. Catch and eat.\nAllies, increasing. Hee.", "kamakiri_fc1", 0],
      :no => ["\\n<Mantis Girl>Hee...", "kamakiri_fc1", 2],
    },
    205 => { # カイコ娘
      :actor_id => 235, :denominator => 4,
      :question => ["\\n<Silkworm Girl>Can I be your ally too?\nAmong insects, I'm the smart one.", "kaiko_fc1", 0],
      :yes => ["\\n<Silkworm Girl>Fufu, my adventure begins here.\nLet's put all our enemies in cocoons.", "kaiko_fc1", 0],
      :no => ["\\n<Silkworm Girl>I don't care. I'll just be in a cocoon here...", "kaiko_fc1", 2],
    },
    206 => { # アルラ・アルム
      :actor_id => 236, :denominator => 4,
      :question => ["\\n<Alra Arum>Will you take me as well?\nI'm pretty good at magic.", "a_alm_fc1", 0],
      :yes => ["\\n<Alra Arum>All right, let's get along.\nI'm not good at offense, but I'll support you.", "a_alm_fc1", 0],
      :no => ["\\n<Alra Arum>I'm sorry I can't help you...", "a_alm_fc1", 2],
    },
    208 => { # アルラ・ボア
      :actor_id => 237, :denominator => 4,
      :question => ["\\n<Alra Vore>Aha, you're quite interesting.\nFollowing you seems like it would be fun...", "a_vore_fc1", 0],
      :yes => ["\\n<Alra Vore>Good, leave it to me.\nIt seems I'll be eating a lot from now on...", "a_vore_fc1", 0],
      :no => ["\\n<Alra Vore>Whaaaat? Boring...", "a_vore_fc1", 2],
    },
    216 => { # モス娘
      :actor_id => 243, :denominator => 4,
      :question => ["\\n<Moth Girl>Can I come with you too?\nMy moth scale attacks should be useful.", "moss_fc1", 0],
      :yes => ["\\n<Moth Girl>Great, nice to meet you.\nMy moth scales will confuse your enemies!", "moss_fc1", 0],
      :no => ["\\n<Moth Girl>So you don't want pests for companions?", "moss_fc1", 2],
    },
    219 => { # スズメバチ娘
      :actor_id => 244, :denominator => 3,
      :question => ["\\n<Hornet Girl>TAKE ME WITH YOU.\nI'LL FOLLOW YOUR COMMANDS.", "suzumebati_fc1", 0],
      :yes => ["\\n<Hornet Girl>I'LL FOLLOW ANYWHERE.\nDESTROY OUR ENEMIES.", "suzumebati_fc1", 0],
      :no => ["\\n<Hornet Girl>DISCARDED...", "suzumebati_fc1", 1],
    },
    225 => { # ジェリー娘
      :actor_id => 246, :denominator => 4,
      :question => ["\\n<Jelly Girl>Is it interesting outside the spring...?\nJust once, I'd like to go outside too...", "jelly_fc1", 0],
      :yes => ["\\n<Jelly Girl>The outside world seems very interesting...\nI'm sure there are lots of delicious things, too...", "jelly_fc1", 0],
      :no => ["\\n<Jelly Girl>I want to go outside the spring...", "jelly_fc1", 2],
    },
    226 => { # ブロブ娘
      :actor_id => 247, :denominator => 4,
      :question => ["\\n<Blob Girl>Hey, bring me along too.\nI want to eat a lot of different thiiings♪", "blob_fc1", 0],
      :yes => ["\\n<Blob Girl>Yay! It's time for a buffet! ♪", "blob_fc1", 0],
      :no => ["\\n<Blob Girl>It's fine, I'll just eat stray humans here, then...", "blob_fc1", 2],
    },
    230 => { # パープルスライム
      :actor_id => 248, :denominator => 5,
      :question => ["\\n<Purple Slime>Recently, being a leader has been burdensome.\nIf possible, I'd like to follow someone else for a change.", "slime_purple_fc1", 0],
      :yes => ["\\n<Purple Slime>Please take care of my kin too.\nUse our power as you wish.", "slime_purple_fc1", 0],
      :no => ["\\n<Purple Slime>I suppose I should remain the leader, then...", "slime_purple_fc1", 2],
    },
    233 => { # アリ娘
      :actor_id => 249, :denominator => 3,
      :question => ["\\n<Ant Girl>LET US AID YOU.\nLET US TRAVEL TOGETHER.", "ant_fc1", 0],
      :yes => ["\\n<Ant Girl>COUNT ON US.\nWE SHALL WORK HARD.", "ant_fc1", 0],
      :no => ["\\n<Ant Girl>ARE WE NOT NEEDED?", "ant_fc1", 1],
    },
    234 => { # オートマータ娘
      :actor_id => 250, :denominator => 2,
      :question => ["\\n<Automata Girl>Master, please take me.\nI have battle programs installed as well.", "artm_fc1", 0],
      :yes => ["\\n<Automata Girl>My special skill is suicide bombing.\nThank you, master.", "artm_fc1", 0],
      :no => ["\\n<Automata Girl>Understood. I shall blow myself up right away.", "artm_fc1", 1],
    },
    235 => { # パイズリ人形
      :actor_id => 251, :denominator => 4,
      :question => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 0],
      :yes => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 0],
      :no => ["\\n<Paizuri Doll>.........", "paizuridoll_fc1", 2],
    },
    236 => { # スキュラ
      :actor_id => 252, :denominator => 3,
      :question => ["\\n<Scylla>You're interesting.\nCan I be one of your companions?", "scylla_fc1", 0],
      :yes => ["\\n<Scylla>Fufu, nice to meet you.", "scylla_fc1", 0],
      :no => ["\\n<Scylla>Such a rude boy! You'll regret this!", "scylla_fc1", 0],
    },
    237 => { # メデューサ
      :actor_id => 253, :denominator => 4,
      :question => ["\\n<Medusa>Rejoice, for I will lend you my strength! I take it there are no complaints?", "medusa_fc1", 0],
      :yes => ["\\n<Medusa>Good.\nEveryone who bothers me will be turned to stone.", "medusa_fc1", 0],
      :no => ["\\n<Medusa>...I'll turn you to stone. Prepare yourself...", "medusa_fc1", 2],
    },
    238 => { # あげは娘
      :actor_id => 254, :denominator => 4,
      :question => ["\\n<Butterfly Girl>Make me your friend too, big bro.\nDespite how I look, I have confidence in my strength.", "ageha_fc1", 0],
      :yes => ["\\n<Butterfly Girl>Ufufu, I'm looking forward to working with you.\nLet's do our best together.", "ageha_fc1", 0],
      :no => ["\\n<Butterfly Girl>So I can't be your companion.\nIt feels a little lonely...", "ageha_fc1", 2],
    },
    239 => { # ブロム娘
      :actor_id => 255, :denominator => 4,
      :question => ["\\n<Brom Girl>Hey, can you fulfill my wish?\nI'd like to have a normal body, free of poison.", "blom_fc1", 0],
      :yes => ["\\n<Brom Girl>Will you look for a way to make my body normal?\nThen I'll travel and help out too!", "blom_fc1", 1],
      :no => ["\\n<Brom Girl>I see. So you can't do it either...", "blom_fc1", 2],
    },
    240 => { # ウォーマー
      :actor_id => 256, :denominator => 3,
      :question => ["\\n<Warmer>Take me... too...", "warmer_fc1", 0],
      :yes => ["\\n<Warmer>Together... go...\nGreetings...", "warmer_fc1", 0],
      :no => ["\\n<Warmer>Left... behind...", "warmer_fc1", 2],
    },
    241 => { # グール
      :actor_id => 257, :denominator => 5,
      :question => ["\\n<Ghoul>Auuuu...\nTogether...", "gool_fc1", 0],
      :yes => ["\\n<Ghoul>Hungry... Food...", "gool_fc1", 0],
      :no => ["\\n<Ghoul>Uwaa... Ahhh...", "gool_fc1", 0],
    },
    244 => { # フェイクジェリー
      :actor_id => 258, :denominator => 5,
      :question => ["\\n<Fake Jelly>Uhm, could you take me as well?\nAn adventure sounds nice right now...", "fakejelly_fc1", 0],
      :yes => ["\\n<Fake Jelly>Fufu, thank you.\nI'm so excited to go on an adventure!", "fakejelly_fc1", 0],
      :no => ["\\n<Fake Jelly>Ara, how rude...", "fakejelly_fc1", 2],
    },
    245 => { # ウィングハーピー
      :actor_id => 259, :denominator => 4,
      :question => ["\\n<Wing Harpy>Can I go with you?", "w_hapy_fc1", 0],
      :yes => ["\\n<Wing Harpy>All right, let's work together!", "w_hapy_fc1", 1],
      :no => ["\\n<Wing Harpy>Coldhearted...", "w_hapy_fc1", 0],
    },
    246 => { # ナイトハーピー
      :actor_id => 260, :denominator => 4,
      :question => ["\\n<Harpy Knight>I have pride in my abilities. Would you take me along with you?", "k_hapy_fc1", 0],
      :yes => ["\\n<Harpy Knight>I'm confident in my spear and my feathers!\nCount on me!", "k_hapy_fc1", 0],
      :no => ["\\n<Harpy Knight>So you don't need help?\nAre you confident, or do you just look down on me...?", "k_hapy_fc1", 2],
    },
    247 => { # マッドゴーレム娘
      :actor_id => 261, :denominator => 5,
      :question => ["\\n<Mud Golem Girl>UPDATING MASTER INFORMATION...\nWILL YOU BE MY NEW MASTER?", "madgolem_fc1", 0],
      :yes => ["\\n<Mud Golem Girl>UNDERSTOOD.\nINFORMATION UPDATED.", "madgolem_fc1", 0],
      :no => ["\\n<Mud Golem Girl>MASTER SEARCH CONTINUING...", "madgolem_fc1", 0],
    },
    249 => { # ハナビラカマキリ娘
      :actor_id => 263, :denominator => 4,
      :question => ["\\n<Flower Mantis Girl>I shall accompany you.\nI'll slice apart any foe with my sickles...", "h_kamakiri_fc1", 0],
      :yes => ["\\n<Flower Mantis Girl>Then, let us go...\nUntil my clothes are dyed red with blood...", "h_kamakiri_fc1", 0],
      :no => ["\\n<Flower Mantis Girl>I see. It seems I'm not good enough to be an ally...", "h_kamakiri_fc1", 2],
    },
    250 => { # ブラックゴーレム
      :actor_id => 264, :denominator => 4,
      :question => ["\\n<Black Golem>Hey, make me an ally too!", "bgolem_fc1", 0],
      :yes => ["\\n<Black Golem>It's my dream to evolve into the ultimate homunculus!\nNice to meet yooooou!", "bgolem_fc1", 1],
      :no => ["\\n<Black Golem>Please take me aloooong!", "bgolem_fc1", 2],
    },
    251 => { # 狐獣
      :actor_id => 265, :denominator => 4,
      :question => ["\\n<Feral Kitsune>I'll come with you.\nYou look awfully unreliable...", "kitunezyu_fc1", 0],
      :yes => ["\\n<Feral Kitsune>Thank you...\nD-don't drag your feet!", "kitunezyu_fc1", 0],
      :no => ["\\n<Feral Kitsune>Huh, what?!", "kitunezyu_fc1", 2],
    },
    252 => { # くのいち三尾
      :actor_id => 266, :denominator => 4,
      :question => ["\\n<Three-Tailed Kunoichi>Hmm, you're quite the interesting fellow indeed...\nVery well, I shall lend you my strength.", "kunoitisanbi_fc1", 0],
      :yes => ["\\n<Three-Tailed Kunoichi>Fufu... I shall show you the power of a ninja.\nOr perhaps, if you so desire, I could show you the sexual techniques of a kunoichi...?", "kunoitisanbi_fc1", 0],
      :no => ["\\n<Three-Tailed Kunoichi>It seems you've underestimated me.\nVery well. I won't beg. Farewell...", "kunoitisanbi_fc1", 2],
    },
    253 => { # もののふ四尾
      :actor_id => 267, :denominator => 4,
      :question => ["\\n<Four-Tailed Samurai>You have great skills...\nI would like to hone my blade under you.", "mononohuyonbi_fc1", 0],
      :yes => ["\\n<Four-Tailed Samurai>Then we shall conquer together.\nLet us both hone our blades!", "mononohuyonbi_fc1", 0],
      :no => ["\\n<Four-Tailed Samurai>A samurai's blade is a lonely thing...", "mononohuyonbi_fc1", 2],
    },
    256 => { # 溶岩娘
      :actor_id => 269, :denominator => 4,
      :question => ["\\n<Lava Girl>Even though I'm lava, I'd like to go outside once in a while. Will you fulfill my wish?", "yougan_fc1", 0],
      :yes => ["\\n<Lava Girl>I'll be in your care of me from now on.\nI have to be careful not to cool down...", "yougan_fc1", 0],
      :no => ["\\n<Lava Girl>I guess I should stay in the volcano after all...", "yougan_fc1", 2],
    },
    257 => { # デーモンラミア
      :actor_id => 270, :denominator => 4,
      :question => ["\\n<Demon Lamia>Hey, let me be your companion.\nI'll lend you the strength of a high-ranking lamia.", "lamiad_fc1", 0],
      :yes => ["\\n<Demon Lamia>You might be a tough guy, but you don't have bad eyes. If you treat me well, I'll wrap around you in return...♪", "lamiad_fc1", 1],
      :no => ["\\n<Demon Lamia>I want nothing to do with humans who lack a discerning eye.", "lamiad_fc1", 2],
    },
    258 => { # デーモンスキュラ
      :actor_id => 271, :denominator => 4,
      :question => ["\\n<Demon Scylla>Will you take me along as a companion?\nMy tentacles can knock down your enemies...", "scyllad_fc1", 0],
      :yes => ["\\n<Demon Scylla>Fufu, looks like I can come.\nPlease make use of these tentacles however you like...", "scyllad_fc1", 0],
      :no => ["\\n<Demon Scylla>You'll become prey to these tentacles someday...", "scyllad_fc1", 2],
    },
    259 => { # セイレーン
      :actor_id => 272, :denominator => 3,
      :question => ["\\n<Siren>Take me with you.\nWouldn't you like to listen to my song as much as you want?", "seiren_fc1", 0],
      :yes => ["\\n<Siren>We're allies from this day forward then.\nTry not to get watered down by my song...", "seiren_fc1", 0],
      :no => ["\\n<Siren>I'll water you down with my song someday...", "seiren_fc1", 2],
    },
    260 => { # サンゴ娘
      :actor_id => 273, :denominator => 5,
      :question => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :yes => ["\\n<Coral Girl>.........", "sango_fc1", 0],
      :no => ["\\n<Coral Girl>.........", "sango_fc1", 0],
    },
    261 => { # ヒトデ娘
      :actor_id => 274, :denominator => 4,
      :question => ["\\n<Starfish Girl>Will you take me with you as well?\nI'd like to come up on land once in a while...", "hitode_fc1", 0],
      :yes => ["\\n<Starfish Girl>Fufu, I'm glad...\nI can finally say goodbye to the sea.", "hitode_fc1", 0],
      :no => ["\\n<Starfish Girl>Am I useless...?\nYou have a narrow mind.", "hitode_fc1", 2],
    },
    265 => { # アークジェリー
      :actor_id => 278, :denominator => 4,
      :question => ["\\n<Arch Jelly>I shall follow you...\nCan we go together...?", "arkjelly_fc1", 0],
      :yes => ["\\n<Arch Jelly>It's nice to meet you.\nLet's play lots and lots, ok?", "arkjelly_fc1", 0],
      :no => ["\\n<Arch Jelly>Electric shock, bzzzzt...", "arkjelly_fc1", 2],
    },
    266 => { # エルダースキュラ
      :actor_id => 279, :denominator => 4,
      :question => ["\\n<Elder Scylla>Take me with you...\nI'll show you the power of a high-ranking scylla...", "e_scylla_fc1", 0],
      :yes => ["\\n<Elder Scylla>Well then, I'm in your care...\nYou can count on me for anything...", "e_scylla_fc1", 0],
      :no => ["\\n<Elder Scylla>You lack good judgment...", "e_scylla_fc1", 2],
    },
    268 => { # サキュバス
      :actor_id => 281, :denominator => 5,
      :question => ["\\n<Succubus>Hey, don't you feel like taking the Succubus Harem along? Every day will be like heaven...ufufu.", "succubuses_fc2", 0],
      :yes => ["\\n<Succubus>In that case, the Harem is yours from today on.\nBut don't forget to please us...", "succubuses_fc2", 0],
      :no => ["\\n<Succubus>Are you so stoic you don't need the Harem?\nIsn't abstinence boring?", "succubuses_fc2", 2],
    },
    272 => { # メイキュバス
      :actor_id => 282, :denominator => 5,
      :question => ["\\n<Maidcubus>Allow me to accompany you, Master.\nPlease leave the service to me.", "maycubbus_fc1", 0],
      :yes => ["\\n<Maidcubus>I look forward to working for you.\nShall I serve you at once?", "maycubbus_fc1", 0],
      :no => ["\\n<Maidcubus>I see, that's regrettable...\nPlease see me again if you have another opportunity.", "maycubbus_fc1", 2],
    },
    279 => { # マダムインセクト
      :actor_id => 290, :denominator => 4,
      :question => ["\\n<Madame Insect>I love strong gentlemen...\nWon't you please take me along as well?", "madaminsect_fc1", 0],
      :yes => ["\\n<Madame Insect>Fufu, I look forward to working with you.\nI would like to suck your semen some time...", "madaminsect_fc1", 0],
      :no => ["\\n<Madame Insect>To refuse a lady's request...\nYou seem to be lacking the qualities of a gentleman.", "madaminsect_fc1", 2],
    },
    280 => { # マダムアンブレラ
      :actor_id => 291, :denominator => 4,
      :question => ["\\n<Madame Umbrella>Fufu... Why don't you make me your companion?\nI've grown a little tired of waiting for prey here...", "madamumbrella_fc1", 0],
      :yes => ["\\n<Madame Umbrella>Man-hunting will come second from here on out.\nFufufu, I'm looking forward to it...", "madamumbrella_fc1", 0],
      :no => ["\\n<Madame Umbrella>You won't take me outside...?\nYou're more cruel than I am, leaving me here to die.", "madamumbrella_fc1", 2],
    },
    281 => { # アラディア
      :actor_id => 292, :denominator => 5,
      :question => ["\\n<Aradia>Shall I lend you a hand...?", "aradia_fc1", 0],
      :yes => ["\\n<Aradia>Then we shall go together...", "aradia_fc1", 0],
      :no => ["\\n<Aradia>How disappointing... I shall see you again...", "aradia_fc1", 0],
    },
    283 => { # バジリスク娘
      :actor_id => 297, :denominator => 4,
      :question => ["\\n<Basilisk>You're an interesting human...\nOkay, I'll be your companion too.", "basilisk_fc1", 0],
      :yes => ["\\n<Basilisk>Come to think of it, it's been a long time since I've gone outside the volcano. Okay now, I'm counting on you to look out for me.", "basilisk_fc1", 0],
      :no => ["\\n<Basilisk>Are my abilities unnecessary?\nI'm very confident in them...", "basilisk_fc1", 2],
    },
    284 => { # ドラゴン娘
      :actor_id => 298, :denominator => 4,
      :question => ["\\n<Dragon Girl>You're the first person I've ever met with such skill. It would be nice if you took me along.", "dragon_fc1", 0],
      :yes => ["\\n<Dragon Girl>I'll show you the power of a mighty dragon!", "dragon_fc1", 0],
      :no => ["\\n<Dragon Girl>How disgraceful...\nTurning me away like this.", "dragon_fc1", 2],
    },
    287 => { # ゼラチナスキューブ娘
      :actor_id => 299, :denominator => 5,
      :question => ["\\n<Gelatinous Cube Girl>Ufufu, won't you make me your friend?\nAs a reward, I'll wrap you up...", "gelatinous_fc1", 0],
      :yes => ["\\n<Gelatinous Cube Girl>Ufu, please take care of me in advance.\nThe reward will come after we're friends...", "gelatinous_fc1", 0],
      :no => ["\\n<Gelatinous Cube Girl>Idiot!", "gelatinous_fc1", 2],
    },
    288 => { # 妖鬼
      :actor_id => 300, :denominator => 4,
      :question => ["\\n<Youki>Damn, I don't wanna be exterminated. Okay, I'll become your servant!", "youki_fc1", 0],
      :yes => ["\\n<Youki>Got it, I'm all yours!\nI was starting to run out of punks to beat down, anyway!", "youki_fc1", 0],
      :no => ["\\n<Youki>Is that so...\nDamn it, what am I supposed to do with all this raw power?", "youki_fc1", 2],
    },
    289 => { # 虎娘
      :actor_id => 301, :denominator => 5,
      :question => ["\\n<Tiger Girl>You have considerable strength, I like that...\nTake me along as a friend too.", "tora_fc1", 0],
      :yes => ["\\n<Tiger Girl>You will see the power of a tiger stands equal to a dragon. I absolutely won't fall behind the dragons!", "tora_fc1", 1],
      :no => ["\\n<Tiger Girl>Do you think the tiger is inferior to the dragon...?", "tora_fc1", 2],
    },
    290 => { # ヴァンパイア
      :actor_id => 302, :denominator => 3,
      :question => ["\\n<Vampire>Your strength is remarkable.\nIt would be appropriate for a noble of the night to accompany you...", "vampire_fc1", 0],
      :yes => ["\\n<Vampire>Nice to meet you...fufufu.\nI may treat myself to your blood once in a while.", "vampire_fc1", 0],
      :no => ["\\n<Vampire>I wonder if you dislike the ominousness of the night...?", "vampire_fc1", 2],
    },
    291 => { # ジェライラ
      :actor_id => 303, :denominator => 5,
      :question => ["\\n<Jellaila>Are you willing to take me with you...?", "jeraira_fc1", 0],
      :yes => ["\\n<Jellaila>Then I shall play a melody of rendezvous...", "jeraira_fc1", 0],
      :no => ["\\n<Jellaila>I shall play a song of parting...", "jeraira_fc1", 2],
    },
    292 => { # リボ・リボ
      :actor_id => 304, :denominator => 5,
      :question => ["\\n<Ribo-Ribo>Requesting permission for accompaniment...", "libolibo_fc1", 0],
      :yes => ["\\n<Ribo-Ribo>From now on, I shall accompany you...", "libolibo_fc1", 0],
      :no => ["\\n<Ribo-Ribo>Resuming normal duties...", "libolibo_fc1", 2],
    },
    293 => { # アンフィル
      :actor_id => 305, :denominator => 5,
      :question => ["\\n<Amphil>Please take me...", "anfill_fc1", 0],
      :yes => ["\\n<Amphil>Yes, that is good...", "anfill_fc1", 0],
      :no => ["\\n<Amphil>You can't...", "anfill_fc1", 2],
    },
    294 => { # ツィンケル
      :actor_id => 306, :denominator => 5,
      :question => ["\\n<Twinkell>We would like to follow you...\nThe outside is incredibly vast, isn't it?", "twinkel_fc1", 0],
      :yes => ["\\n<Twinkell>Ahahaha, I'm so happy...\nI'm really looking forward to it.", "twinkel_fc1", 0],
      :no => ["\\n<Twinkell>That's not funny...", "twinkel_fc1", 2],
    },
    299 => { # シーアネモネ
      :actor_id => 307, :denominator => 4,
      :question => ["\\n<Sea Anemone Girl>Won't you take me with you?\nHow about I squeeze you inside me as a reward...?", "seaanemone_fc1", 0],
      :yes => ["\\n<Sea Anemone Girl>Then I'm in your care from now on.\nLet me know whenever you want to be squeezed.", "seaanemone_fc1", 0],
      :no => ["\\n<Sea Anemone Girl>Then I'll let you do as you please...", "seaanemone_fc1", 0],
    },
    300 => { # 水龍娘
      :actor_id => 308, :denominator => 5,
      :question => ["\\n<Sea Dragon Girl>Will you not make me your companion?\nI shall lend you my exceptional powers...", "suiryu_fc1", 0],
      :yes => ["\\n<Sea Dragon Girl>Hurrah! It's nice to meet you...\n...No, I trust you will take care of me.", "suiryu_fc1", 1],
      :no => ["\\n<Sea Dragon Girl>Eh? You won't take me along...?", "suiryu_fc1", 2],
    },
    301 => { # マンタ娘
      :actor_id => 309, :denominator => 5,
      :question => ["\\n<Manta Girl>Take me with you.\nI'll definitely be helpful.", "manta_fc1", 1],
      :yes => ["\\n<Manta Girl>Behold the Manta's power with your own eyes!", "manta_fc1", 1],
      :no => ["\\n<Manta Girl>If that's your decision...", "manta_fc1", 2],
    },
    302 => { # イッカク娘
      :actor_id => 310, :denominator => 5,
      :question => ["\\n<Narwhal Girl>I, the Lord of the Seas, shall lend you a hand!\nYou should be grateful...", "ikkaku_fc1", 1],
      :yes => ["\\n<Narwhal Girl>Anyone who stands in your way will become a victim of my horn. They will follow the same fate as many ships...", "ikkaku_fc1", 1],
      :no => ["\\n<Narwhal Girl>How disgraceful...\nTo refuse my cooperation!", "ikkaku_fc1", 2],
    },
    303 => { # トリックフェアリー
      :actor_id => 311, :denominator => 5,
      :question => ["\\n<Trick Fairy>Hey hey, take me along!\nI want to cause lots of mischief!～♪", "trickfairy_fc1", 0],
      :yes => ["\\n<Trick Fairy>Yaaay, let's cause mischief! ♪", "trickfairy_fc1", 0],
      :no => ["\\n<Trick Fairy>I want to cause mischief!", "trickfairy_fc1", 2],
    },
    304 => { # アマゾネスエルフ
      :actor_id => 312, :denominator => 4,
      :question => ["\\n<Elf Amazoness>You have great skills.\nI'll lend you my aid...", "amazoneself_fc1", 0],
      :yes => ["\\n<Elf Amazoness>Leave the heavy lifting to me.\nNow then, let's go!", "amazoneself_fc1", 0],
      :no => ["\\n<Elf Amazoness>You don't need my help...?\nYou're quite confident in yourself.", "amazoneself_fc1", 2],
    },
    305 => { # カーバンクル娘
      :actor_id => 313, :denominator => 4,
      :question => ["\\n<Carbuncle Girl>I am also known as the Beast Magician, and I shall lend you my powers. You don't have any complaints, do you...?", "carbuncle_fc1", 0],
      :yes => ["\\n<Carbuncle Girl>Very well, I shall go with you in that case.\nEven though I'm a beast, I refuse to receive any rough treatment.", "carbuncle_fc1", 0],
      :no => ["\\n<Carbuncle Girl>Were you expecting a speed or power beast...?", "carbuncle_fc1", 2],
    },
    306 => { # ジャイガンテック娘
      :actor_id => 314, :denominator => 5,
      :question => ["\\n<Gigantic Girl>You're strong!\nI'll come too! Let's go!", "gigantic_fc1", 0],
      :yes => ["\\n<Gigantic Girl>All right! I'll rampage a lot!", "gigantic_fc1", 0],
      :no => ["\\n<Gigantic Girl>Uooooooh!", "gigantic_fc1", 2],
    },
    309 => { # フォレストアルラウネ
      :actor_id => 317, :denominator => 4,
      :question => ["\\n<Forest Alraune>Take me along as well...\nJust once, I would like to travel the world.", "f_alraune_fc1", 0],
      :yes => ["\\n<Forest Alraune>Thank you...\nI look forward to traveling the world.", "f_alraune_fc1", 0],
      :no => ["\\n<Forest Alraune>I wanted to travel the world...", "f_alraune_fc1", 2],
    },
    310 => { # フォレストドリアード
      :actor_id => 318, :denominator => 4,
      :question => ["\\n<Forest Dryad>Won't you please let me be your companion?\nThe plant tribe cannot travel afar on their own...", "f_dryad_fc1", 0],
      :yes => ["\\n<Forest Dryad>Thank you...!\nI'll do my best not to inconvenience you.", "f_dryad_fc1", 0],
      :no => ["\\n<Forest Dryad>Is that so...\nI guess I'm a bother after all...", "f_dryad_fc1", 2],
    },
    311 => { # ワルラウネ
      :actor_id => 319, :denominator => 4,
      :question => ["\\n<Walraune>Hey, will you let me join your group?\nI haven't been able to go even a little crazy lately.", "walraune_fc1", 0],
      :yes => ["\\n<Walraune>From this day on, I'm your companion. Fufu, this doesn't look boring...", "walraune_fc1", 0],
      :no => ["\\n<Walraune>Do you have a bad feeling about this...?\nMaybe you're right.", "walraune_fc1", 2],
    },
    312 => { # ドリアード
      :actor_id => 320, :denominator => 3,
      :question => ["\\n<Dryad>Fwaah, you're really strong.\nI want to be your friend...", "dryad_fc1", 0],
      :yes => ["\\n<Dryad>Yaaay, I hope you treat me well!\nI'll do my best! ♪", "dryad_fc1", 0],
      :no => ["\\n<Dryad>Am I no good, how disappointing...", "dryad_fc1", 2],
    },
    313 => { # ドリアード
      :actor_id => 321, :denominator => 3,
      :question => ["\\n<Dark Dryad>You're really strong.\nI'll be your companion too.", "dryad_fc1", 4],
      :yes => ["\\n<Dark Dryad>Fufu, it's nice to meet you.\nWe're going to have a lot of fun...", "dryad_fc1", 4],
      :no => ["\\n<Dark Dryad>Am I useless? Narrow-minded man...", "dryad_fc1", 6],
    },
    316 => { # ナイトマーメイド
      :actor_id => 324, :denominator => 3,
      :question => ["\\n<Mermaid Knight>You're considerably skilled.\nWon't you make me your companion as well?", "knight_mermaid_fc1", 0],
      :yes => ["\\n<Mermaid Knight>I shall lend you my sword for a while.\nI will not disappoint you...", "knight_mermaid_fc1", 0],
      :no => ["\\n<Mermaid Knight>Is my sword unreliable...?", "knight_mermaid_fc1", 2],
    },
    317 => { # ジェネラルマーメイド
      :actor_id => 325, :denominator => 4,
      :question => ["\\n<Mermaid General>How have I, of the queen's royal guard, been defeated...?\nI would like to polish my skills under you for a little while.", "g_marmaid_fc1", 0],
      :yes => ["\\n<Mermaid General>Fufu... I'm in your care from now on.\nI will acquire true strength, worthy of a royal guard.", "g_marmaid_fc1", 0],
      :no => ["\\n<Mermaid General>You're coldhearted...", "g_marmaid_fc1", 2],
    },
    318 => { # ローレライ
      :actor_id => 326, :denominator => 3,
      :question => ["\\n<Lorelei>I will go together with you too...", "loreley_fc1", 0],
      :yes => ["\\n<Lorelei>Nice to meet you...", "loreley_fc1", 0],
      :no => ["\\n<Lorelei>Are my abilities insufficient...?", "loreley_fc1", 0],
    },
    321 => { # アラクネ
      :actor_id => 330, :denominator => 5,
      :question => ["\\n<Arachne>Hey hey, take us with you too.\nWe won't cause you any trouble...", "arachnes_fc2", 0],
      :yes => ["\\n<Arachne>Yaaay, please take care of us! ♪\nWe're depending on you to feed the three of us! ♪", "arachnes_fc2", 0],
      :no => ["\\n<Arachne>Is three of us overdoing it after all?\nI guess it can't be helped...", "arachnes_fc2", 2],
    },
    324 => { # あやし土蜘蛛
      :actor_id => 331, :denominator => 5,
      :question => ["\\n<Tsuchigumo>You're quite capable...\nWill you not let me accompany you as well?", "tutigumo_fc1", 0],
      :yes => ["\\n<Tsuchigumo>I appreciate your kindness.\nI shall return the favor, fufufu...", "tutigumo_fc1", 0],
      :no => ["\\n<Tsuchigumo>If that is what you want, I don't particularly mind...", "tutigumo_fc1", 2],
    },
    325 => { # アラクネロード
      :actor_id => 332, :denominator => 5,
      :question => ["\\n<Arachne Lord>You're an interesting human...\nFufu, you should take me with you.", "alakneload_fc1", 0],
      :yes => ["\\n<Arachne Lord>Come, let's go.\nThose who stand in my way shall fall prey to my sticky thread.", "alakneload_fc1", 0],
      :no => ["\\n<Arachne Lord>It's irritating to be rejected so bluntly...", "alakneload_fc1", 2],
    },
    326 => { # アトラク＝ナクア
      :actor_id => 333, :denominator => 5,
      :question => ["\\n<Atlach-Nacha>Let me lend you my power...", "atlach_fc1", 0],
      :yes => ["\\n<Atlach-Nacha>Fufu, nice to meet you...", "atlach_fc1", 0],
      :no => ["\\n<Atlach-Nacha>Disappointing...", "atlach_fc1", 0],
    },
    328 => { # コンキスタ
      :actor_id => 335, :denominator => 4,
      :question => ["\\n<Conquista>You're intriguing, I'll lend you my power.", "conquista_fc1", 0],
      :yes => ["\\n<Conquista>Now, let's go together...", "conquista_fc1", 0],
      :no => ["\\n<Conquista>Guh, how rude!", "conquista_fc1", 2],
    },
    329 => { # ヴェンデッタ
      :actor_id => 336, :denominator => 4,
      :question => ["\\n<Vendetta>Shall I assist you as well...?", "vendetta_fc1", 0],
      :yes => ["\\n<Vendetta>Then we shall go together...", "vendetta_fc1", 0],
      :no => ["\\n<Vendetta>Are you dissatisfied with me...?", "vendetta_fc1", 2],
    },
    330 => { # エルダーヴァンパイア
      :actor_id => 337, :denominator => 4,
      :question => ["\\n<Elder Vampire>I am a high-ranking vampire...\nAllow me to lend you my power...", "e_vampire_fc1", 0],
      :yes => ["\\n<Elder Vampire>You can count on my power...", "e_vampire_fc1", 0],
      :no => ["\\n<Elder Vampire>I have been looked down on...", "e_vampire_fc1", 0],
    },
    334 => { # マスターシャドウ
      :actor_id => 342, :denominator => 4,
      :question => ["\\n<Master Shadow>Me...\nTake me with you...", "m_shadow_fc1", 0],
      :yes => ["\\n<Master Shadow>No one... No one shall interfere with you...", "m_shadow_fc1", 1],
      :no => ["\\n<Master Shadow>Possess...\nI'll curse you...", "m_shadow_fc1", 2],
    },
    335 => { # 煙々羅
      :actor_id => 343, :denominator => 5,
      :question => ["\\n<Enenra>Do you need my strength...?\nIf you wish, I shall go with you.", "enenra_fc1", 0],
      :yes => ["\\n<Enenra>Hmm, you have a good attitude.\nI'll be counting on you from now on.", "enenra_fc1", 0],
      :no => ["\\n<Enenra>R-really...\nHmm, just don't pursue those who leave you.", "enenra_fc1", 2],
    },
    336 => { # 麒麟
      :actor_id => 344, :denominator => 5,
      :question => ["\\n<Kirin>You should consider this an honor.\nI shall lend you my strength.", "kirin_fc1", 0],
      :yes => ["\\n<Kirin>Yes, that is good.\nMy thunder shall destroy any adversary.", "kirin_fc1", 0],
      :no => ["\\n<Kirin>You are a rude boy...", "kirin_fc1", 2],
    },
    337 => { # 蛇骨女
      :actor_id => 345, :denominator => 5,
      :question => ["\\n<Jakotsu-Onna>I find you quite interesting, human...\nWould you be interested at all in making use of me?", "zyakotuonna_fc1", 1],
      :yes => ["\\n<Jakotsu-Onna>Yes, that will do nicely...\nI shall entrust my power to you for a while.", "zyakotuonna_fc1", 1],
      :no => ["\\n<Jakotsu-Onna>Am I still inferior to the little harlots here...?", "zyakotuonna_fc1", 2],
    },
    338 => { # ベヒーモス娘
      :actor_id => 346, :denominator => 3,
      :question => ["\\n<Behemoth>I'm coming too.\nI don't need to tell you about the power of the strongest beast...", "behemoth_fc1", 0],
      :yes => ["\\n<Behemoth>Got it, I'll rampage as much as I want.\nTry your best not to get caught up in it...", "behemoth_fc1", 0],
      :no => ["\\n<Behemoth>What...?!\nI've never felt so insulted in my life!", "behemoth_fc1", 2],
    },
    339 => { # ワイバーン
      :actor_id => 347, :denominator => 4,
      :question => ["\\n<Wyvern>You're exceptional, so I'll lend you my power. There aren't many opportunities to befriend sky dragons, are there?", "wyvern_fc1", 0],
      :yes => ["\\n<Wyvern>Heh, you've made  the right choice.\nI'll show you the power of a raging sky dragon!", "wyvern_fc1", 0],
      :no => ["\\n<Wyvern>Hmph, what a let-down...\nThat's enough, I'm going home.", "wyvern_fc1", 2],
    },
    340 => { # 巨竜娘
      :actor_id => 348, :denominator => 4,
      :question => ["\\n<Kyoryuu>Can we go together...?", "kyoryuu_fc1", 0],
      :yes => ["\\n<Kyoryuu>Nice to meet you...", "kyoryuu_fc1", 0],
      :no => ["\\n<Kyoryuu>I can't...? Is it because I'm too big...?", "kyoryuu_fc1", 2],
    },
    341 => { # モンクサキュバス
      :actor_id => 349, :denominator => 4,
      :question => ["\\n<Succubus Monk>You're really strong.\nIt's decided, I'll come along with you!", "monk_sucubuss_fc1", 0],
      :yes => ["\\n<Succubus Monk>Then I'm in your care.\nI'll beat down whatever gets in your way!", "monk_sucubuss_fc1", 1],
      :no => ["\\n<Succubus Monk>Eeeh?! Why not?!\nAre you saying I'm useless?!", "monk_sucubuss_fc1", 2],
    },
    342 => { # モンクデーモン
      :actor_id => 350, :denominator => 4,
      :question => ["\\n<Demon Monk>You're a great master, boy.\nYou won't mind if you're accompanied by my might?", "monk_demon_fc1", 0],
      :yes => ["\\n<Demon Monk>Looks like I can come...\nFrom now on, I'll swing my fists for you.", "monk_demon_fc1", 0],
      :no => ["\\n<Demon Monk>I guess I'm not to your liking...", "monk_demon_fc1", 2],
    },
    343 => { # スキュラサーバント
      :actor_id => 351, :denominator => 5,
      :question => ["\\n<Scylla Servant>Your skills are marvelous.\nLet me join you as well...", "scylla_s_fc1", 0],
      :yes => ["\\n<Scylla Servant>Is that fine with you?\nThen I look forward to working with you.", "scylla_s_fc1", 0],
      :no => ["\\n<Scylla Servant>Is that so...\nI'll have some free time in that case.", "scylla_s_fc1", 2],
    },
    344 => { # ヴィーヴル娘
      :actor_id => 352, :denominator => 5,
      :question => ["\\n<Vouivre Girl>You're very powerful.\nWon't you let me be your friend too...?", "vouivre_fc1", 0],
      :yes => ["\\n<Vouivre Girl>I'm an unusual monster with holy powers.\nI'll use it for your sake!", "vouivre_fc1", 1],
      :no => ["\\n<Vouivre Girl>You don't need someone odd like me...?", "vouivre_fc1", 3],
    },
    351 => { # 氷の魔女
      :actor_id => 353, :denominator => 5,
      :question => ["\\n<Ice Witch>I will become your friend...\nMy ice magic will never fall behind...", "icemaze_fc1", 0],
      :yes => ["\\n<Ice Witch>In that case, I'm in your care.\nJust don't take me anywhere too hot.", "icemaze_fc1", 0],
      :no => ["\\n<Ice Witch>Hmph, do whatever you want...", "icemaze_fc1", 2],
    },
    352 => { # シロクマ娘
      :actor_id => 354, :denominator => 3,
      :question => ["\\n<Polar Bear Girl>Let's go together...\nIt's cold here...", "shirokuma_fc1", 1],
      :yes => ["\\n<Polar Bear Girl>From now on, let's snuggle together...♪", "shirokuma_fc1", 1],
      :no => ["\\n<Polar Bear Girl>Cold...", "shirokuma_fc1", 2],
    },
    353 => { # 天使兵
      :actor_id => 355, :denominator => 3,
      :question => ["\\n<Angel Soldier>I see you are quite powerful.\nWould you allow me to fight alongside you?", "angels_fc1", 0],
      :yes => ["\\n<Angel Soldier>Then I shall accompany you from now on.\nI still have much to learn, but I'll work my hardest.", "angels_fc1", 0],
      :no => ["\\n<Angel Soldier>Really...\nI suppose we're just low-ranked angels after all.", "angels_fc1", 2],
    },
    358 => { # トリニティ
      :actor_id => 356, :denominator => 5,
      :question => ["\\n<Trinity>Ah, what a strong man...\nLet us follow you too.", "trinity_fc1", 3],
      :yes => ["\\n<Trinity>Then let us go.", "trinity_fc1", 3],
      :no => ["\\n<Trinity>Then please come again...", "trinity_fc1", 3],
    },
    361 => { # ウラヌス
      :actor_id => 357, :denominator => 5,
      :question => ["\\n<Uranus>You have a righteous heart, don't you?\nI, who carries the power of the Holy Beast, shall go with you.", "uranus_fc1", 0],
      :yes => ["\\n<Uranus>Then we shall go together.\nYou can depend on me.", "uranus_fc1", 0],
      :no => ["\\n<Uranus>Is that so...\nThat is okay with me.", "uranus_fc1", 2],
    },
    362 => { # エリシエル
      :actor_id => 358, :denominator => 5,
      :question => ["\\n<Eliciel>Don't you feel like taking me along?\nMy mission is to ward evil people away from the forbidden fruit.", "erisiel_fc1", 0],
      :yes => ["\\n<Eliciel>Then I am your companion from now on.\nLet us ward the monsters away from the forbidden fruit.", "erisiel_fc1", 0],
      :no => ["\\n<Eliciel>Is that so...\nIt can't be helped then.", "erisiel_fc1", 2],
    },
    363 => { # キューピッド
      :actor_id => 359, :denominator => 3,
      :question => ["\\n<Cupid>Hey, take me with you too!\nI want to play moooore!", "cupid_fc1", 0],
      :yes => ["\\n<Cupid>Yaaay, it's nice to meet you!\nI'll help you out with your work! ♪", "cupid_fc1", 0],
      :no => ["\\n<Cupid>No faaair, you're mean!", "cupid_fc1", 2],
    },
    364 => { # ヴァルキリー
      :actor_id => 360, :denominator => 3,
      :question => ["\\n<Valkyrie>Your skills are top-notch...\nI must observe you.", "valkyrie_fc1", 0],
      :yes => ["\\n<Valkyrie>Then I shall accompany you...\nDon't do anything strange as I watch from above.", "valkyrie_fc1", 0],
      :no => ["\\n<Valkyrie>Do you have a guilty conscience?\nThat also seems like something which needs to be monitored...", "valkyrie_fc1", 2],
    },
    366 => { # ヘリエル
      :actor_id => 361, :denominator => 5,
      :question => ["\\n<Heriel>Take me with you too...\nIt sounds very fascinating...", "heriel_fc1", 0],
      :yes => ["\\n<Heriel>Leave the rest to me...\nI'll send them all to heaven...", "heriel_fc1", 0],
      :no => ["\\n<Heriel>Hate...", "heriel_fc1", 2],
    },
    367 => { # アルシエル
      :actor_id => 362, :denominator => 5,
      :question => ["\\n<Alciel>Let us conquer together...\nThe world will know the teachings of Ilias...", "arusiel_fc1", 0],
      :yes => ["\\n<Alciel>All for the sake of Ilias...", "arusiel_fc1", 0],
      :no => ["\\n<Alciel>Are you mocking Ilias...?", "arusiel_fc1", 2],
    },
    373 => { # キメラビースト
      :actor_id => 363, :denominator => 4,
      :question => ["\\n<Chimera Beast>Leader candidate acknowledged.\nPermit accompaniment...?", "c_beast_fc1", 0],
      :yes => ["\\n<Chimera Beast>Updating leader information.\nI will accompany you from now on...", "c_beast_fc1", 0],
      :no => ["\\n<Chimera Beast>Denied...?", "c_beast_fc1", 1],
    },
    374 => { # S-2
      :actor_id => 364, :denominator => 4,
      :question => ["\\n<S-2>Awawa...\nTake me along too...", "c_s2_fc1", 0],
      :yes => ["\\n<S-2>Awawa, let's be friends...", "c_s2_fc1", 0],
      :no => ["\\n<S-2>Awawa...", "c_s2_fc1", 2],
    },
    375 => { # A-3
      :actor_id => 365, :denominator => 4,
      :question => ["\\n<A-3>Hey, will you take me with you?\nI would like to find a way to return to my original body...", "c_a3_fc1", 0],
      :yes => ["\\n<A-3>Lend me a hand...\nSo I can return to my original body...", "c_a3_fc1", 0],
      :no => ["\\n<A-3>I will stay like this forever...that's it.", "c_a3_fc1", 0],
    },
    376 => { # AD-5
      :actor_id => 366, :denominator => 4,
      :question => ["\\n<AD-5>Let's become friends...", "AD-5_fc1", 0],
      :yes => ["\\n<AD-5>Let's go...", "AD-5_fc1", 0],
      :no => ["\\n<AD-5>.........", "AD-5_fc1", 0],
    },
    377 => { # Q-5
      :actor_id => 367, :denominator => 5,
      :question => ["\\n<Q-5>I want to go outside...\nSpin spin around...", "q_5_fc1", 0],
      :yes => ["\\n<Q-5>Nice to meet you... Spin spin spin...", "q_5_fc1", 0],
      :no => ["\\n<Q-5>Spin spin, spin spin...", "q_5_fc1", 0],
    },
    462 => { # サキュバスSR
      :actor_id => 829, :denominator => 4,
      :question => ["\\n<Lilin>Ufufu... I'd like to go with you♡", "succubusq_fc1", 0],
      :yes => ["\\n<Lilin>I'll be sure to make them come plenty...ufufu♡", "succubusq_fc1", 0],
      :no => ["\\n<Lilin>Ara... How disappointing.", "succubusq_fc1", 2],
    },
    492 => { # サキュバスJ
      :actor_id => 831, :denominator => 4,
      :question => ["\\n<Ayane>Hey, let's be friends...", "succubusj_fc1", 0],
      :yes => ["\\n<Ayane>Aha, that makes me happy♪", "succubusj_fc1", 0],
      :no => ["\\n<Ayane>You're cruel...", "succubusj_fc1", 2],
    },
    494 => { # サキュバスSR
      :actor_id => 830, :denominator => 4,
      :question => ["\\n<Mare>Hey... Do you want to play with me?", "succubusm_fc1", 0],
      :yes => ["\\n<Mare>We'll have lots of fun together, fufufu...", "succubusm_fc1", 0],
      :no => ["\\n<Mare>Oh... I'm disappointed to hear that.", "succubusm_fc1", 2],
    },
    502 => { # コックローチ娘
      :actor_id => 404, :denominator => 2,
      :question => ["\\n<Cockroach Girl>Hey, will you let me join you too?\nI'll be happy to eat any leftovers you've got...", "cockroacha_fc1", 0],
      :yes => ["\\n<Cockroach Girl>Nice to meet you!\nI'm confident in my speed and tenacity!", "cockroacha_fc1", 1],
      :no => ["\\n<Cockroach Girl>Are you telling me you won't let a roach come along?!", "cockroacha_fc1", 2],
    },
    503 => { # スピードローチ
      :actor_id => 405, :denominator => 3,
      :question => ["\\n<Speed Roach>Won't you let a roach join you...?\nYou may not like us, but...", "cockroachb_fc1", 0],
      :yes => ["\\n<Speed Roach>Thank you...\nYou're being so kind to me, even though I'm a roach...", "cockroachb_fc1", 1],
      :no => ["\\n<Speed Roach>As I thought, roaches are hated...", "cockroachb_fc1", 2],
    },
    507 => { # マジックポット
      :actor_id => 407, :denominator => 2,
      :question => ["\\n<Magic Pot>Let me be your friend, please!", "magicpot_fc1", 0],
      :yes => ["\\n<Magic Pot>Yaaay, yippeeee!\nBy the way, gimme an elixir!", "magicpot_fc1", 3],
      :no => ["\\n<Magic Pot>Jerk...", "magicpot_fc1", 2],
    },
    508 => { # 豆狸
      :actor_id => 408, :denominator => 1,
      :question => ["\\n<Junior Tanuki>Ponpoko... Will you take me along too?\nI'd like to train with someone strong...", "mametanuki_fc1", 0],
      :yes => ["\\n<Junior Tanuki>Then I'll do my best!\nI'm sure I'll become stronger than the kitsune, right?", "mametanuki_fc1", 0],
      :no => ["\\n<Junior Tanuki>That's so...mean...", "mametanuki_fc1", 2],
    },
    509 => { # 上狸
      :actor_id => 409, :denominator => 3,
      :question => ["\\n<High Tanuki>I see you're a famous hero!\nLet me train with you, pleeease!", "zyoutanuki_fc1", 0],
      :yes => ["\\n<High Tanuki>Hooray! Thank you sooo much, and please take care of me!", "zyoutanuki_fc1", 1],
      :no => ["\\n<High Tanuki>I won't give up!", "zyoutanuki_fc1", 2],
    },
    510 => { # 忍狸
      :actor_id => 410, :denominator => 3,
      :question => ["\\n<Shinobitanuki>Hey hey, take me with you too!", "shinobitanuki_fc1", 0],
      :yes => ["\\n<Shinobitanuki>Hooray! I'm gonna help out a lot!", "shinobitanuki_fc1", 1],
      :no => ["\\n<Shinobitanuki>Ehhh? Why nooot?!", "shinobitanuki_fc1", 2],
    },
    511 => { # 化け狸
      :actor_id => 411, :denominator => 3,
      :question => ["\\n<Bakedanuki>Ufufu, you're a spirited boy...\nWould you like me to join you as well?", "baketanuki_fc1", 0],
      :yes => ["\\n<Bakedanuki>Please take good care of me, ufufu...", "baketanuki_fc1", 1],
      :no => ["\\n<Bakedanuki>My my, how heartless...", "baketanuki_fc1", 2],
    },
    515 => { # くのいちエルフ
      :actor_id => 414, :denominator => 3,
      :question => ["\\n<Kunoichi Elf>Will you not let us serve you?\nYou'll feel like you're in heaven every day...", "kunoitielf2_fc4", 0],
      :yes => ["\\n<Kunoichi Elf>Having a kunoichi harem is a luxury.\nWe'll make sure to soften you up enough...", "kunoitielf2_fc4", 1],
      :no => ["\\n<Kunoichi Elf>Are you leading an ascetic life?\nIsn't that harsh...?", "kunoitielf2_fc4", 2],
    },
    518 => { # くのいちサキュバス
      :actor_id => 415, :denominator => 4,
      :question => ["\\n<Kunoichi Succubus>You're quite a splendid man, aren't you?\nWould you mind having me around you?", "kuno_succubus_fc1", 0],
      :yes => ["\\n<Kunoichi Succubus>Are you expecting more from my talents or my body? In either case, I ask you to treat me well.", "kuno_succubus_fc1", 0],
      :no => ["\\n<Kunoichi Succubus>A man should know it's important to be broad-minded.", "kuno_succubus_fc1", 2],
    },
    519 => { # くのいちハーピー
      :actor_id => 416, :denominator => 4,
      :question => ["\\n<Kunoichi Harpy>You're really good, aren't you?\nWould you let me join you too?", "kuno_hapy_fc1", 0],
      :yes => ["\\n<Kunoichi Harpy>Fufufu... It's nice to meet you.\nYour enemies will be confused by my speed.", "kuno_hapy_fc1", 0],
      :no => ["\\n<Kunoichi Harpy>I guess... you won't let me come along.", "kuno_hapy_fc1", 2],
    },
    520 => { # くのいちスキュラ
      :actor_id => 417, :denominator => 4,
      :question => ["\\n<Kunoichi Scylla>You seem to be really skilled.\nWould you like me to join you as well?", "kuno_scylla_fc1", 0],
      :yes => ["\\n<Kunoichi Scylla>In that case, please treat me well from now on.\nThis is also my first time working with friends.", "kuno_scylla_fc1", 0],
      :no => ["\\n<Kunoichi Scylla>Loneliness is part of being a kunoichi... I am familiar with this.", "kuno_scylla_fc1", 2],
    },
    521 => { # くのいちアラクネ
      :actor_id => 418, :denominator => 4,
      :question => ["\\n<Kunoichi Arachne>That was splendid...\nI'd like to lend you my strength as well.", "kuno_arachne_fc1", 0],
      :yes => ["\\n<Kunoichi Arachne>Look forward to my skills...\nI shall work very hard for you.", "kuno_arachne_fc1", 0],
      :no => ["\\n<Kunoichi Arachne>To be turned down... How disgraceful...", "kuno_arachne_fc1", 2],
    },
    526 => { # エルダーサキュバス
      :actor_id => 421, :denominator => 3,
      :question => ["\\n<Elder Succubus>Fufufu... You're wonderful.\nWould you plan on making me your mistress--no, your companion?", "esuccubus_fc1", 0],
      :yes => ["\\n<Elder Succubus>Fufu... You're responsible for what I do now, okay?", "esuccubus_fc1", 1],
      :no => ["\\n<Elder Succubus>What a boorish man, refusing a woman's invitation...", "esuccubus_fc1", 2],
    },
    527 => { # グランセントール
      :actor_id => 422, :denominator => 2,
      :question => ["\\n<Grand Centaur>Indeed... I see you are quite the master of arms.\nIf you desire it, I shall ride into battle together with you.", "gran_centa_fc1", 0],
      :yes => ["\\n<Grand Centaur>All right, my spear is now in your hands.\nYou too, should take care not to let me down with ungraceful fighting.", "gran_centa_fc1", 1],
      :no => ["\\n<Grand Centaur>Huuuuh?", "gran_centa_fc1", 2],
    },
    528 => { # エイビス娘
      :actor_id => 423, :denominator => 3,
      :question => ["\\n<Aevis Girl>You have seen the monstrous bird's power for yourself... Now, you may take me with you!", "abis_fc1", 1],
      :yes => ["\\n<Aevis Girl>I shall rampage across the battlefield as you wish. Try your best not to get caught up in it.", "abis_fc1", 1],
      :no => ["\\n<Aevis Girl>Are you afraid of me...?", "abis_fc1", 2],
    },
    529 => { # 陰陽五尾
      :actor_id => 424, :denominator => 4,
      :question => ["\\n<Five-Tailed Taoist>I shall offer to accompany you from now on.\nFufu, wouldn't that be reassuring...?", "onmyougobi_fc1", 0],
      :yes => ["\\n<Five-Tailed Taoist>That's good...\nI will show you the wonders of my taoism.", "onmyougobi_fc1", 0],
      :no => ["\\n<Five-Tailed Taoist>You refused me...!\nThis is incredibly vexing.", "onmyougobi_fc1", 2],
    },
    530 => { # 花魁六尾
      :actor_id => 425, :denominator => 4,
      :question => ["\\n<Six-Tailed Courtesan>You there, boy. You're quite a lovely fellow.\nHow about it, would you let me come with you?", "oiranrokubi_fc1", 0],
      :yes => ["\\n<Six-Tailed Courtesan>Hmm, that is good.\nYou can just let me soften you with my body...", "oiranrokubi_fc1", 0],
      :no => ["\\n<Six-Tailed Courtesan>I cannot even capture this young boy's heart...\nI suppose I've been losing my touch.", "oiranrokubi_fc1", 2],
    },
    545 => { # アモルドール
      :actor_id => 429, :denominator => 10,
      :question => ["\\n<Amor Doll>I'm getting tired of being cooped up here. Won't you let me out of here...?", "amoldoll_fc1", 0],
      :yes => ["\\n<Amor Doll>From now on, I will serve you. It is my desire to control everything with these hands...", "amoldoll_fc1", 1],
      :no => ["\\n<Amor Doll>Why? Did you have a bad feeling...?", "amoldoll_fc1", 2],
    },
    548 => { # ペルセポネー
      :actor_id => 430, :denominator => 10,
      :question => ["\\n<Persephone>I also want to see the outside world...To spread death and joy...", "persephone_fc1", 0],
      :yes => ["\\n<Persephone>If you ever want to experience pleasure, just let me know.I'll squeeze you with this body anytime...", "persephone_fc1", 1],
      :no => ["\\n<Persephone>Are you planning to keep me confined here...?", "persephone_fc1", 2],
    },
    549 => { # トリロバイト
      :actor_id => 431, :denominator => 10,
      :question => ["\\n<Trilobite>We're going too!Take us with you...!", "trilobite_fc1", 0],
      :yes => ["\\n<Trilobite>Nice to meet you! From now on, we're companions! Please take care of us!", "trilobite_fc1", 1],
      :no => ["\\n<Trilobite>You're so heartless! Cruel, incompetent, and heartless!", "trilobite_fc1", 2],
    },
    554 => { # マリエル
      :actor_id => 435, :denominator => 6,
      :question => ["\\n<Mariel>Do you intend to make me your companion?I may be inexperienced, but I should be able to help.", "mariel_fc1", 0],
      :yes => ["\\n<Mariel>I may be inexperienced, but please take care of me. I will use my power for your sake.", "mariel_fc1", 1],
      :no => ["\\n<Mariel>Why?What was wrong with me...?", "mariel_fc1", 3],
    },
    555 => { # 淫乳天女
      :actor_id => 436, :denominator => 8,
      :question => ["\\n<Busty Tennyo>  You're such a good kid.  Shall big sis follow you too?", "tennyo_fc1", 0],
      :yes => ["\\n<Busty Tennyo>Well then, nice to meet you.Don't you dare mess with big sis's boobs♪", "tennyo_fc1", 1],
      :no => ["\\n<Busty Tennyo>Oh, you don't want me?That's a shame...", "tennyo_fc1", 2],
    },
    556 => { # キメラテンタクル
      :actor_id => 437, :denominator => 8,
      :question => ["\\n<Chimera Tentacle>Won't you make me your companion?My tentacle SKL are exquisite...", "c_tentacle_fc1", 0],
      :yes => ["\\n<Chimera Tentacle>With these tentacles, I'll torment any enemy. If you ever want to experience the tentacles, don't hesitate to ask...", "c_tentacle_fc1", 1],
      :no => ["\\n<Chimera Tentacle>...Eventually, you too will fall prey to my tentacles.", "c_tentacle_fc1", 2],
    },
    558 => { # アリエル
      :actor_id => 438, :denominator => 4,
      :question => ["\\n<Ariel>I, the Archangel, shall accompany you.You are far too dangerous to be left alone...", "ariel_fc1", 3],
      :yes => ["\\n<Ariel>Then, let us go together.If you ever go out of control, I will stop you.", "ariel_fc1", 3],
      :no => ["\\n<Ariel>You are always being watched by the heavens...", "ariel_fc1", 3],
    },
    559 => { # ラナエル
      :actor_id => 439, :denominator => 8,
      :question => ["\\n<Ranael>Interesting man...I'll accompany you for a while.", "ranael_fc1", 0],
      :yes => ["\\n<Ranael>Well then, let's go anywhere. I will watch over the path you walk...", "ranael_fc1", 0],
      :no => ["\\n<Ranael>I wonder why... Why is it...", "ranael_fc1", 2],
    },
    562 => { # ナガエル
      :actor_id => 440, :denominator => 8,
      :question => ["\\n<Nagael> I need to make some observations before judging you. Okay, let's give you a little grace...", "nagael_fc1", 0],
      :yes => ["\\n<Nagael>Then, I shall observe you. Since I will be accompanying you, you should exercise some restraint.", "nagael_fc1", 0],
      :no => ["\\n<Nagael>If you refuse even observation...Then you will not escape severe judgment.", "nagael_fc1", 2],
    },
    563 => { # キメラメデュラハン
      :actor_id => 441, :denominator => 8,
      :question => ["\\n<Chimera Medullahan>You're really good...I'll become your companion.", "c_medulahan_fc1", 0],
      :yes => ["\\n<Chimera Medullahan>Fufufu, nice to meet you...I'll be of great use to you...", "c_medulahan_fc1", 1],
      :no => ["\\n<Chimera Medullahan>Remember this, snake monsters are very persistent...", "c_medulahan_fc1", 2],
    },
    565 => { # ラタエル
      :actor_id => 442, :denominator => 6,
      :question => ["\\n<Latael>Strong power... I'm also drawn to it...", "ratael_fc1", 0],
      :yes => ["\\n<Latael>From now on, we're together...", "ratael_fc1", 1],
      :no => ["\\n<Latael>Oh, that's unfortunate...", "ratael_fc1", 2],
    },
    566 => { # リファイール
      :actor_id => 443, :denominator => 10,
      :question => ["\\n<Leafael>Hmm, you may take me along.My divinity must be made known to the world.", "rifaiel_fc1", 0],
      :yes => ["\\n<Leafael> At , let's show the world what pleasure is.  You may also be left in the care...", "rifaiel_fc1", 1],
      :no => ["\\n<Leafael> Hmph, what a rude person.", "rifaiel_fc1", 2],
    },
    568 => { # ギリエル
      :actor_id => 444, :denominator => 4,
      :question => ["\\n<Giriel>You're super strong!Make me your companion too!", "giriel_fc1", 0],
      :yes => ["\\n<Giriel>Alright, let's raise some hell!!", "giriel_fc1", 0],
      :no => ["\\n<Giriel>What's the deal?!", "giriel_fc1", 2],
    },
    569 => { # トルーパーロイド
      :actor_id => 445, :denominator => 4,
      :question => ["\\n<Trooperoid>Hey, take me with you too!I'll go wild to my heart's content!", "trooperloid_fc1", 0],
      :yes => ["\\n<Trooperoid>Then, I'll follow you. Let me go wild!", "trooperloid_fc1", 0],
      :no => ["\\n<Trooperoid>Well, fine then, I don't care!", "trooperloid_fc1", 4],
    },
    571 => { # サビリエル
      :actor_id => 446, :denominator => 8,
      :question => ["\\n<Sabiriel>What a splendid warrior...Won't you take me along as well?", "sabiriel_fc1", 0],
      :yes => ["\\n<Sabiriel> Let's put this sword to good use!", "sabiriel_fc1", 1],
      :no => ["\\n<Sabiriel>Are you saying I'm not strong enough...? How mortifying...", "sabiriel_fc1", 2],
    },
    574 => { # ムズキエル
      :actor_id => 447, :denominator => 6,
      :question => ["\\n<Muzukiel>You are a wonderful person...I suppose I could accompany you for a while.", "muzukiel_fc1", 0],
      :yes => ["\\n<Muzukiel>Fufu, nice to meet you.If you don't mind, I'd also like to ask for some mating.", "muzukiel_fc1", 1],
      :no => ["\\n<Muzukiel>Do you dislike insects...?", "muzukiel_fc1", 2],
    },
    575 => { # シルキエル
      :actor_id => 448, :denominator => 8,
      :question => ["\\n<Silkiel>Hey, make me your companion too.It seems like it would be fun to follow you...", "silkiel_fc1", 0],
      :yes => ["\\n<Silkiel>That's the spirit...Sometimes, I need to stretch my wings and relax.", "silkiel_fc1", 1],
      :no => ["\\n<Silkiel>You're a narrow-minded human...", "silkiel_fc1", 2],
    },
    577 => { # ベリエル
      :actor_id => 449, :denominator => 8,
      :question => ["\\n<Berryelle>You're a very interesting human...Hey, can I follow you?", "berryel_fc1", 0],
      :yes => ["\\n<Berryelle>Well then, nice to meet you...Please satisfy my hunger as well.", "berryel_fc1", 1],
      :no => ["\\n<Berryelle>Oh, is that so...Then, I might as well eat you up.", "berryel_fc1", 2],
    },
    578 => { # キメラプラント
      :actor_id => 450, :denominator => 6,
      :question => ["\\n<Chimera Plant>I will... follow you...", "evilprant_fc1", 0],
      :yes => ["\\n<Chimera Plant>  I will turn your enemies... into nutrients...", "evilprant_fc1", 0],
      :no => ["\\n<Chimera Plant>No good...", "evilprant_fc1", 0],
    },
    579 => { # リヴァエル
      :actor_id => 451, :denominator => 8,
      :question => ["\\n<Revel>I'm interested in your life...Won't you take me with you?", "revel_fc1", 0],
      :yes => ["\\n<Revel>I'm interested in your life... Won't you take me with you? I'll watch your way of life until the very end... And in the end, you will be reborn.", "revel_fc1", 0],
      :no => ["\\n<Revel>Is there something you feel guilty about...?", "revel_fc1", 0],
    },
    584 => { # キメラタン
      :actor_id => 452, :denominator => 6,
      :question => ["\\n<Chimera Tongue>Do you have no intention of taking me with you...? I'll lick any enemy until they're powerless.", "c_tangh_fc1", 0],
      :yes => ["\\n<Chimera Tongue>Do you have no intention of taking me along...? I can neutralize any enemy by licking them all over.", "c_tangh_fc1", 1],
      :no => ["\\n<Chimera Tongue>I see... How boring.", "c_tangh_fc1", 2],
    },
    585 => { # キメラバグ
      :actor_id => 453, :denominator => 4,
      :question => ["\\n<Chimera Bug>Fufu... You're strong, big brother.Won't you take me with you?", "c_bug_fc1", 0],
      :yes => ["\\n<Chimera Bug>I'm happy, fufufu...I'd be even happier if I could bear your child...", "c_bug_fc1", 1],
      :no => ["\\n<Chimera Bug>Oh, that's unfortunate...I wanted to bear your child...", "c_bug_fc1", 2],
    },
    586 => { # キメラスラッグ
      :actor_id => 454, :denominator => 6,
      :question => ["\\n<Chimera Slug>I want to go with you too...Won't you make me your companion...?", "c_slag_fc1", 0],
      :yes => ["\\n<Chimera Slug>Fufufu... I'll follow you anywhere...", "c_slag_fc1", 0],
      :no => ["\\n<Chimera Slug>I see... Well, that's fine...", "c_slag_fc1", 0],
    },
    587 => { # キメラドリアード
      :actor_id => 455, :denominator => 10,
      :question => ["\\n<Chimera Dryad>Co...mpan...ion...", "c_dryad_fc1", 0],
      :yes => ["\\n<Chimera Dryad>Ple...ase...Nice...to...meet...you...", "c_dryad_fc1", 0],
      :no => ["\\n<Chimera Dryad>...................", "c_dryad_fc1", 0],
    },
    589 => { # カトブレパス
      :actor_id => 456, :denominator => 8,
      :question => ["\\n<Catoblepas>You're interesting. I've decided, make me your companion.", "catoblepas_fc1", 0],
      :yes => ["\\n<Catoblepas>Leave the fighting to me.Wherever I go, only statues will remain...", "catoblepas_fc1", 0],
      :no => ["\\n<Catoblepas>How humiliating, to have my invitation rejected...", "catoblepas_fc1", 0],
    },
    590 => { # テュポーン
      :actor_id => 457, :denominator => 8,
      :question => ["\\n<Typhon>Ahaha, take me with you too. I want to swallow all the monsters whole from all over the place...♪", "typhon_fc1", 0],
      :yes => ["\\n<Typhon>Well then, nice to meet you. Looks like I'll get to feast on some delicious prey...♪", "typhon_fc1", 0],
      :no => ["\\n<Typhon>Someday, I'll eat you too...", "typhon_fc1", 0],
    },
    593 => { # トラップテミス
      :actor_id => 459, :denominator => 4,
      :question => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :yes => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
      :no => ["\\n<Themis Trap>................", "traptemis_fc1", 0],
    },
    595 => { # フーリエル
      :actor_id => 460, :denominator => 8,
      :question => ["\\n<Furiel>That power exceeds my expectations... May I continue to observe you closely in the future?", "furiel_fc1", 0],
      :yes => ["\\n<Furiel>Then, let's be together for a while.", "furiel_fc1", 1],
      :no => ["\\n<Furiel>It was such a good opportunity...", "furiel_fc1", 2],
    },
    596 => { # ドレインプラント
      :actor_id => 461, :denominator => 6,
      :question => ["\\n<Drain Plant>Please take me with you... No need to worry, I can move on my own.", "drainplant_fc1", 0],
      :yes => ["\\n<Drain Plant>This body, a living plant... I will dedicate it to you.", "drainplant_fc1", 1],
      :no => ["\\n<Drain Plant>I see... Then, I'll stay here for a while...", "drainplant_fc1", 2],
    },
    597 => { # ドレインロイド
      :actor_id => 462, :denominator => 8,
      :question => ["\\n<Drainroid>Please let me operate outside the lab...", "drainloid_fc1", 0],
      :yes => ["\\n<Drainroid>Understood, I will proceed at full capacity...", "drainloid_fc1", 0],
      :no => ["\\n<Drainroid>Unforgivable...", "drainloid_fc1", 2],
    },
    598 => { # ハンディロイド
      :actor_id => 463, :denominator => 8,
      :question => ["\\n<Handyroid>Let's use my SKL for the good of the world. Now, please take me with you.", "handyloid_fc1", 0],
      :yes => ["\\n<Handyroid>Those who are waiting to be squeezed... I will thoroughly squeeze them dry.", "handyloid_fc1", 0],
      :no => ["\\n<Handyroid>I see... Then let's continue squeezing the test subjects here.", "handyloid_fc1", 2],
    },
    601 => { # メイドエンジェル
      :actor_id => 464, :denominator => 4,
      :question => ["\\n<Angel Maid>I want to serve by your side... ...Is that alright?", "maid_angel_fc1", 0],
      :yes => ["\\n<Angel Maid>Then, I will serve you plenty♪", "maid_angel_fc1", 1],
      :no => ["\\n<Angel Maid>I-I see...", "maid_angel_fc1", 2],
    },
    602 => { # コックエンジェル
      :actor_id => 465, :denominator => 4,
      :question => ["\\n<Angel Cook>I see that my cooking SKL are needed! How about hiring an angel cook?", "cooc_angel_fc1", 0],
      :yes => ["\\n<Angel Cook>Alright, I'll show you my SKL!", "cooc_angel_fc1", 1],
      :no => ["\\n<Angel Cook>Rejected... My pride...", "cooc_angel_fc1", 2],
    },
    603 => { # ワイティエル
      :actor_id => 466, :denominator => 6,
      :question => ["\\n<Whiteyel>I want to fight alongside you...", "whiteyel_fc1", 0],
      :yes => ["\\n<Whiteyel>I'm happy! Well then, let's go together...", "whiteyel_fc1", 1],
      :no => ["\\n<Whiteyel>I-I see... I'm sad...", "whiteyel_fc1", 2],
    },
    604 => { # ラミアンロイド
      :actor_id => 467, :denominator => 6,
      :question => ["\\n<Lamiaroid>Hey hey, won't you take me with you? I want to try out various units on my whole body.", "lamianloid_fc1", 0],
      :yes => ["\\n<Lamiaroid>Well then, nice to meet you! If there's any unit you want to use, just let me know.", "lamianloid_fc1", 3],
      :no => ["\\n<Lamiaroid>Boring!", "lamianloid_fc1", 2],
    },
    611 => { # エンディエル
      :actor_id => 468, :denominator => 8,
      :question => ["\\n<Endiel>I want to accompany you to hone my pleasure SKL. This is solely for the sake of faithfully completing my mission...", "endiel_fc1", 0],
      :yes => ["\\n<Endiel>Let's proceed for the sake of the mission. If you get tired, please come inside the tent...", "endiel_fc1", 1],
      :no => ["\\n<Endiel>Are you not interested...That's unfortunate.", "endiel_fc1", 2],
    },
    613 => { # レプリカント
      :actor_id => 469, :denominator => 4,
      :question => ["\\n<Replicant>Take me with you, ancient one...I shall observe your way of life.", "replicant_fc1", 0],
      :yes => ["\\n<Replicant>Then, let's go...I hope there is something to learn from the lives of the ancients.", "replicant_fc1", 0],
      :no => ["\\n<Replicant>Are you reluctant to take me along...?", "replicant_fc1", 0],
    },
    616 => { # キメラプリズン
      :actor_id => 470, :denominator => 8,
      :question => ["\\n<Chimera Prison>If I go with you, I might be able to capture various things...", "c_prison_fc1", 0],
      :yes => ["\\n<Chimera Prison>Fill up this cage...", "c_prison_fc1", 0],
      :no => ["\\n<Chimera Prison>I... am not needed...", "c_prison_fc1", 0],
    },
    619 => { # マイコニド
      :actor_id => 471, :denominator => 6,
      :question => ["\\n<Myconid>Friend... become friends...", "maikonido_fc1", 0],
      :yes => ["\\n<Myconid>Friend... friends...", "maikonido_fc1", 0],
      :no => ["\\n<Myconid>...", "maikonido_fc1", 0],
    },
    620 => { # マタンゴ
      :actor_id => 472, :denominator => 8,
      :question => ["\\n<Matango>Hey, hey! Can we come with you too?", "matango_fc1", 6],
      :yes => ["\\n<Matango>Yay! We're all friends now!", "matango_fc1", 6],
      :no => ["\\n<Matango>Oh, I see...", "matango_fc1", 6],
    },
    621 => { # メルティモス
      :actor_id => 473, :denominator => 6,
      :question => ["\\n<Melty Moth>Um... Will you make me your companion?", "meltymoss_fc1", 0],
      :yes => ["\\n<Melty Moth>Th-thank you...", "meltymoss_fc1", 0],
      :no => ["\\n<Melty Moth>....................", "meltymoss_fc1", 0],
    },
    622 => { # メルティローズ
      :actor_id => 474, :denominator => 6,
      :question => ["\\n<Melty Rose>I will... become your companion...", "meltyrose_fc1", 0],
      :yes => ["\\n<Melty Rose>Nice to... meet you...", "meltyrose_fc1", 0],
      :no => ["\\n<Melty Rose>....................", "meltyrose_fc1", 0],
    },
    623 => { # キメラドリアード・ボア
      :actor_id => 475, :denominator => 10,
      :question => ["\\n<Chimera Dryad Vore>Take me... with you...", "c_dryad_vore_fc1", 0],
      :yes => ["\\n<Chimera Dryad Vore>go……", "c_dryad_vore_fc1", 0],
      :no => ["\\n<Chimera Dryad Vore>……………………", "c_dryad_vore_fc1", 0],
    },
    626 => { # 帽子のアリス
      :actor_id => 715, :denominator => 20,
      :question => ["\\n<Hat Alice>May I join your party……?", "alice8thx_fc1", 0],
      :yes => ["\\n<Hat Alice>Hehe…… Thank you.", "alice8thx_fc1", 0],
      :no => ["\\n<Hat Alice>Oh, how rude of me……", "alice8thx_fc1", 0],
    },
    627 => { # 傘のアリス
      :actor_id => 716, :denominator => 20,
      :question => ["\\n<Umbrella Alice>May I join your party……?", "alice8thx_fc1", 1],
      :yes => ["\\n<Umbrella Alice>Hehe…… Thank you.", "alice8thx_fc1", 1],
      :no => ["\\n<Umbrella Alice>Oh, how rude of me……", "alice8thx_fc1", 1],
    },
    628 => { # 赤のアリス
      :actor_id => 717, :denominator => 20,
      :question => ["\\n<Red Alice>May I join your party……?", "alice8thx_fc1", 2],
      :yes => ["\\n<Red Alice>Hehe…… Thank you.", "alice8thx_fc1", 2],
      :no => ["\\n<Red Alice>Oh, how rude of me……", "alice8thx_fc1", 2],
    },
    629 => { # 冬のアリス
      :actor_id => 718, :denominator => 20,
      :question => ["\\n<Winter Alice>May I join your party……?", "alice8thx_fc1", 3],
      :yes => ["\\n<Winter Alice>Hehe…… Thank you.", "alice8thx_fc1", 3],
      :no => ["\\n<Winter Alice>Oh, how rude of me……", "alice8thx_fc1", 3],
    },
    630 => { # 剣のアリス
      :actor_id => 719, :denominator => 20,
      :question => ["\\n<Sword Alice>May I join your party……?", "alice8thx_fc1", 4],
      :yes => ["\\n<Sword Alice>Hehe…… Thank you.", "alice8thx_fc1", 4],
      :no => ["\\n<Sword Alice>Oh, how rude of me……", "alice8thx_fc1", 4],
    },
    631 => { # 武のアリス
      :actor_id => 720, :denominator => 20,
      :question => ["\\n<Martial Alice>May I join your party……?", "alice8thx_fc1", 5],
      :yes => ["\\n<Martial Alice>Hehe…… Thank you.", "alice8thx_fc1", 5],
      :no => ["\\n<Martial Alice>Oh, how rude of me……", "alice8thx_fc1", 5],
    },
    633 => { # 白のアリス
      :actor_id => 722, :denominator => 20,
      :question => ["\\n<White Alice> Could I join your party...?", "alice8thx_fc1", 7],
      :yes => ["\\n<White Alice> Hehe...Thank you in advance.", "alice8thx_fc1", 7],
      :no => ["\\n<White Alice> Oh, excuse me...", "alice8thx_fc1", 7],
    },
    634 => { # 侍のアリス
      :actor_id => 723, :denominator => 20,
      :question => ["\\n<Samurai Alice> Could I join your party...?", "alice8thx_fc2", 0],
      :yes => ["\\n<Samurai Alice> Hehe...Thank you in advance.", "alice8thx_fc2", 0],
      :no => ["\\n<Samurai Alice> Oh, excuse me...", "alice8thx_fc2", 0],
    },
    635 => { # 忍のアリス
      :actor_id => 724, :denominator => 20,
      :question => ["\\n<Ninja Alice> May I join your party...?", "alice8thx_fc2", 1],
      :yes => ["\\n<Ninja Alice> Hehe...Thank you in advance.", "alice8thx_fc2", 1],
      :no => ["\\n<Ninja Alice> Oh, excuse me...", "alice8thx_fc2", 1],
    },
    637 => { # 猟のアリス
      :actor_id => 721, :denominator => 20,
      :question => ["\\n<Hunter Alice> May I join your party...?", "alice8thx_fc1", 6],
      :yes => ["\\n<Hunter Alice>Hehe…… Thank you.", "alice8thx_fc1", 6],
      :no => ["\\n<Hunter Alice>Oh, how rude of me……", "alice8thx_fc1", 6],
    },
    638 => { # 舞のアリス
      :actor_id => 725, :denominator => 20,
      :question => ["\\n<Dancer Alice>May I join your party……?", "alice8thx_fc2", 2],
      :yes => ["\\n<Dancer Alice>Hehe…… Thank you.", "alice8thx_fc2", 2],
      :no => ["\\n<Dancer Alice>Oh, how rude of me……", "alice8thx_fc2", 2],
    },
    639 => { # 呪のアリス
      :actor_id => 727, :denominator => 20,
      :question => ["\\n<Curse Alice>May I join your party……?", "alice8thx_fc2", 4],
      :yes => ["\\n<Curse Alice>Hehe…… Thank you.", "alice8thx_fc2", 4],
      :no => ["\\n<Curse Alice>Oh, how rude of me……", "alice8thx_fc2", 4],
    },
    640 => { # 兎のアリス
      :actor_id => 728, :denominator => 20,
      :question => ["\\n<Rabbit Alice>May I join your party……?", "alice8thx_fc2", 5],
      :yes => ["\\n<Rabbit Alice>Hehe…… Thank you.", "alice8thx_fc2", 5],
      :no => ["\\n<Rabbit Alice>Oh, how rude of me……", "alice8thx_fc2", 5],
    },
    642 => { # 蝕のアリス
      :actor_id => 714, :denominator => 20,
      :question => ["\\n<Devouring Alice>May I join your party……?", "alice8th_fc3", 0],
      :yes => ["\\n<Devouring Alice>Hehe…… Nice to meet you.", "alice8th_fc3", 0],
      :no => ["\\n<Devouring Alice>Oh, how rude of me……", "alice8th_fc3", 0],
    },
    643 => { # 海のアリス
      :actor_id => 726, :denominator => 20,
      :question => ["\\n<Sea Alice>May I join your party……?", "alice8thx_fc2", 3],
      :yes => ["\\n<Sea Alice>Hehe…… Nice to meet you.", "alice8thx_fc2", 3],
      :no => ["\\n<Sea Alice>Oh, how rude of me……", "alice8thx_fc2", 3],
    },
    644 => { # 魔のアリス
      :actor_id => 729, :denominator => 20,
      :question => ["\\n<Magical Alice>May I join your party……?", "alice8thx_fc2", 6],
      :yes => ["\\n<Magical Alice>Hehe…… Nice to meet you.", "alice8thx_fc2", 6],
      :no => ["\\n<Magical Alice>Oh, how rude of me……", "alice8thx_fc2", 6],
    },
    650 => { # ヨモツシコメ
      :actor_id => 476, :denominator => 6,
      :question => ["\\n<Yomotsu-Shikome> I desire... freedom...", "yomotu_fc1", 0],
      :yes => ["\\n<Yomotsu-Shikome> I will follow...", "yomotu_fc1", 0],
      :no => ["\\n<Yomotsu-Shikome> ...................", "yomotu_fc1", 0],
    },
    651 => { # フェルメサーラ
      :actor_id => 477, :denominator => 8,
      :question => ["\\n<Ferme Sara> I desire the outside world... Do you intend to fulfill my wish?", "fermesara_fc1", 0],
      :yes => ["\\n<Ferme Sara> Very well... Then let us go together.", "fermesara_fc1", 0],
      :no => ["\\n<Ferme Sara> After all, it's an unattainable wish...", "fermesara_fc1", 0],
    },
    652 => { # エンジェルグール
      :actor_id => 478, :denominator => 8,
      :question => ["\\n<Angel Ghoul> I want to go out... outside... I want to suck... I want to suck...", "angelghoul_fc1", 0],
      :yes => ["\\n<Angel Ghoul> Outside... I can suck the humans outside...", "angelghoul_fc1", 0],
      :no => ["\\n<Angel Ghoul> I want to go out... I want to go out... I want to go out...", "angelghoul_fc1", 0],
    },
    653 => { # ドラゴンゾンビ娘
      :actor_id => 479, :denominator => 10,
      :question => ["\\n<Dragon Zombie Girl> I'm getting tired of guarding this place. Do you intend to take me outside?", "dragonzonbe_fc1", 0],
      :yes => ["\\n<Dragon Zombie Girl> Very well, then I shall lend you my strength. Now, lead the way outside!", "dragonzonbe_fc1", 1],
      :no => ["\\n<Dragon Zombie Girl> Hmph, what a disappointment...", "dragonzonbe_fc1", 2],
    },
    655 => { # ドッペルエリート
      :actor_id => 505, :denominator => 8,
      :question => ["\\n<Doppel Elite> You must be the original, right? Take me with you too!", "doppele_fc2", 0],
      :yes => ["\\n<Doppel Elite> Thank you! Now, let's embark on our adventure!", "doppele_fc2", 0],
      :no => ["\\n<Doppel Elite> Rights for clones too!", "doppele_fc2", 2],
    },
    656 => { # サルラック娘
      :actor_id => 480, :denominator => 10,
      :question => ["\\n<Sarlacc Girl> Ugh, aah...", "sarlacc_fc1", 0],
      :yes => ["\\n<Sarlacc Girl> Ugh...! Aaah...", "sarlacc_fc1", 0],
      :no => ["\\n<Sarlacc Girl> Ooooh...", "sarlacc_fc1", 0],
    },
    662 => { # シリエル
      :actor_id => 481, :denominator => 6,
      :question => ["\\n<Siriel> I want to stay by your side forever... Is that alright?", "siriel_fc1", 0],
      :yes => ["\\n<Siriel> Hehe... We'll be together forever from now on...", "siriel_fc1", 0],
      :no => ["\\n<Siriel>  I won't give up, I...", "siriel_fc1", 0],
    },
    663 => { # エグエル
      :actor_id => 482, :denominator => 8,
      :question => ["\\n<Eggiel>  I can't find the ideal man to fertilize my egg...  Could you please help me find it...?", "eggel_fc1", 0],
      :yes => ["\\n<Eggiel>Actually, you are the right person...No, no, let's go find the perfect man.", "eggel_fc1", 1],
      :no => ["\\n<Eggiel>  After all, you are the best...", "eggel_fc1", 2],
    },
    664 => { # キメラチャリオッツ
      :actor_id => 483, :denominator => 8,
      :question => ["\\n<Chimera Chariot>  You are very strong, aren't you?  Are you not planning on adding me?", "c_chariot_fc1", 0],
      :yes => ["\\n<Chimera Chariot> By the way, this child's name is Cherry. Best regards to ...", "c_chariot_fc1", 0],
      :no => ["\\n<Chimera Chariot>  Be careful not to get run over by tanks in the future...", "c_chariot_fc1", 0],
    },
    665 => { # ナイトロイド
      :actor_id => 484, :denominator => 8,
      :question => ["\\n<Knightroid>  How far can this power of mine be applied in the world...Would you let me try it out for a little while?", "knightloid_fc1", 0],
      :yes => ["\\n<Knightroid>  Okay, then let's conquer.  I will show my power to the world!", "knightloid_fc1", 1],
      :no => ["\\n<Knightroid>  I see...chivalry is a lonely thing.", "knightloid_fc1", 4],
    },
    666 => { # アサシンロイド
      :actor_id => 485, :denominator => 8,
      :question => ["\\n<Assassinroid>I will lend you my strength. I will eliminate all obstacles for you...?", "assassinloid_fc1", 3],
      :yes => ["\\n<Assassinroid>Leave the assassinations to me. If you wish, I can also handle sexual services...?", "assassinloid_fc1", 3],
      :no => ["\\n<Assassinroid>No need for an assassin in the team...?", "assassinloid_fc1", 3],
    },
    668 => { # ユリエル
      :actor_id => 486, :denominator => 8,
      :question => ["\\n<Yuriel>Take me with you too...", "yuriel_fc1", 0],
      :yes => ["\\n<Yuriel>Blessings upon you...", "yuriel_fc1", 0],
      :no => ["\\n<Yuriel>Be cursed...", "yuriel_fc1", 0],
    },
    669 => { # メルシエル
      :actor_id => 487, :denominator => 8,
      :question => ["\\n<Melciel>Hehe, I like energetic people... Shall I accompany you?", "merusiel_fc1", 0],
      :yes => ["\\n<Melciel>From now on, we are comrades walking the same path. Please take care of me.", "merusiel_fc1", 0],
      :no => ["\\n<Melciel>Oh, is that so...?", "merusiel_fc1", 2],
    },
    670 => { # セバスイール
      :actor_id => 488, :denominator => 10,
      :question => ["\\n<Sebasiel>You seem quite skilled. As the highest-ranking battle angel, it is fitting for me to lend you my strength.", "sebasiel_fc1", 0],
      :yes => ["\\n<Sebasiel>Since I am lending you my strength, I will not tolerate any disgraceful battles. Engrave that into your heart.", "sebasiel_fc1", 1],
      :no => ["\\n<Sebasiel>What exactly are you thinking...? Are you dissatisfied with my power?", "sebasiel_fc1", 2],
    },
    676 => { # ホルミエル
      :actor_id => 489, :denominator => 10,
      :question => ["\\n<Holmiel>You all seem quite formidable. Don't you need my strength?", "holmiel_fc1", 0],
      :yes => ["\\n<Holmiel>Alright, I will lend you my strength!", "holmiel_fc1", 1],
      :no => ["\\n<Holmiel>I see... I won't force you.", "holmiel_fc1", 2],
    },
    677 => { # アプティエル
      :actor_id => 490, :denominator => 10,
      :question => ["\\n<Aptiel>Together... I want to be together too...", "aptiel_fc1", 0],
      :yes => ["\\n<Aptiel>Hehe, ufufufufu...", "aptiel_fc1", 0],
      :no => ["\\n<Aptiel>Curse...", "aptiel_fc1", 1],
    },
    678 => { # クリオネラ
      :actor_id => 491, :denominator => 10,
      :question => ["\\n<Clionera>I'm hungry... I want to go with you...", "clionera_fc1", 0],
      :yes => ["\\n<Clionera>I'll eat all the enemies...", "clionera_fc1", 0],
      :no => ["\\n<Clionera>……………………", "clionera_fc1", 0],
    },
    679 => { # ロズニエル
      :actor_id => 492, :denominator => 10,
      :question => ["\\n<Roseniel>Let's go together. To bring the gospel to the world...", "roseniel_fc1", 0],
      :yes => ["\\n<Roseniel>From now on, we are comrades, fufufu...", "roseniel_fc1", 1],
      :no => ["\\n<Roseniel>That decision is wrong...", "roseniel_fc1", 2],
    },
    680 => { # キュビエル
      :actor_id => 493, :denominator => 10,
      :question => ["\\n<Cubeiel>Will you let me join too...?", "cubiel_fc1", 0],
      :yes => ["\\n<Cubeiel>Fufu, I'm happy...", "cubiel_fc1", 1],
      :no => ["\\n<Cubeiel>How infuriating...", "cubiel_fc1", 2],
    },
    681 => { # ワミエル
      :actor_id => 494, :denominator => 10,
      :question => ["\\n<Wormiel>Since it's a rare opportunity, I'll accompany you too. With my power, things should be easier from here on...", "wormiel_fc1", 0],
      :yes => ["\\n<Wormiel>Be especially careful during battles. Even if you get entangled in my tentacles, I won't care...", "wormiel_fc1", 1],
      :no => ["\\n<Wormiel>You've underestimated me...", "wormiel_fc1", 2],
    },
    691 => { # フェンリル
      :actor_id => 606, :denominator => 4,
      :question => ["\\n<Fenrir>Grrr... You, you're very strong.Take me with you...", "fenrir_fc1", 0],
      :yes => ["\\n<Fenrir>Grrr... Alright, let's go together!If you fall behind, I'll leave you!", "fenrir_fc1", 0],
      :no => ["\\n<Fenrir>Grrrr...", "fenrir_fc1", 2],
    },
    692 => { # ガルキマセラ
      :actor_id => 607, :denominator => 6,
      :question => ["\\n<Garchimacera>There are some interesting humans...I'll accompany you.", "garukimasera_fc1", 0],
      :yes => ["\\n<Garchimacera>Well then, let's go...Leave the escort to me.", "garukimasera_fc1", 1],
      :no => ["\\n<Garchimacera>Hmph... How boring.", "garukimasera_fc1", 2],
    },
    693 => { # グレートオーク
      :actor_id => 608, :denominator => 6,
      :question => ["\\n<Great Orc>You guys are strong!I like you, let's go together?", "greatorc_fc1", 0],
      :yes => ["\\n<Great Orc>Alright, I'll crush anyone who gets in our way!", "greatorc_fc1", 1],
      :no => ["\\n<Great Orc>I see, well, it can't be helped...", "greatorc_fc1", 2],
    },
    694 => { # ランキュバス
      :actor_id => 609, :denominator => 6,
      :question => ["\\n<Lancubus>Ufufu, why not make me your companion...?", "ranccubus_fc1", 0],
      :yes => ["\\n<Lancubus> I won't make you regret it, hehehehe...", "ranccubus_fc1", 1],
      :no => ["\\n<Lancubus> Too bad... Maybe I'll attack another man.", "ranccubus_fc1", 2],
    },
    695 => { # リーキュバス
      :actor_id => 610, :denominator => 6,
      :question => ["\\n<Leecubus> You're amazing!  Hey, make me a friend too!", "leeccubus_fc1", 0],
      :yes => ["\\n<Leecubus> Let me squeeze your sperm tonight~♪", "leeccubus_fc1", 1],
      :no => ["\\n<Leecubus> Terrible! I hate it!", "leeccubus_fc1", 2],
    },
    697 => { # バフォメット
      :actor_id => 612, :denominator => 8,
      :question => ["\\n<Baphomet> I am a servant of the underworld...  I will especially lend you my power.", "baphomet_fc1", 0],
      :yes => ["\\n<Baphomet> I will sacrifice your enemies to the underworld.  Take a look at my magical power...!", "baphomet_fc1", 1],
      :no => ["\\n<Baphomet>Then, let's return to the underworld...", "baphomet_fc1", 2],
    },
    698 => { # くだん
      :actor_id => 613, :denominator => 8,
      :question => ["\\n<Kudan> That power is amazing. Will you take me with you?", "kudan_fc1", 0],
      :yes => ["\\n<Kudan> I understand... I'll entrust my power to you.", "kudan_fc1", 1],
      :no => ["\\n<Kudan> Guh, is this an insult...?!", "kudan_fc1", 2],
    },
    699 => { # ヴェルラウネ
      :actor_id => 614, :denominator => 6,
      :question => ["\\n<Velraune> I like you. Won't you take me with you?", "vellraune_fc1", 0],
      :yes => ["\\n<Velraune> Fufufu, I'm so happy...", "vellraune_fc1", 1],
      :no => ["\\n<Velraune> Eh~? Normally, you wouldn't refuse, right?", "vellraune_fc1", 2],
    },
    700 => { # ネペンデス
      :actor_id => 615, :denominator => 6,
      :question => ["\\n<Nependeath> You're quite charming... Won't you accompany me from now on?", "nependeath_fc1", 0],
      :yes => ["\\n<Nependeath> Ufufu... Nice to meet you.", "nependeath_fc1", 1],
      :no => ["\\n<Nependeath> Someday, I'll bite you from behind...", "nependeath_fc1", 2],
    },
    701 => { # 薔薇貴族
      :actor_id => 616, :denominator => 8,
      :question => ["\\n<Noble Rose> The rose blooms beautifully... How about having one in your hand?", "barakizoku_fc1", 0],
      :yes => ["\\n<Noble Rose> You have a keen eye... I won't make you regret it.", "barakizoku_fc1", 1],
      :no => ["\\n<Noble Rose> D-damn it...!", "barakizoku_fc1", 2],
    },
    706 => { # ボムスライム
      :actor_id => 617, :denominator => 6,
      :question => ["\\n<Bomb Slime>Hey, take me with you!", "bombslime_fc1", 0],
      :yes => ["\\n<Bomb Slime>Alright, I'm gonna explode spectacularly!", "bombslime_fc1", 1],
      :no => ["\\n<Bomb Slime>I see... that's a bummer...", "bombslime_fc1", 2],
    },
    707 => { # リキュルスライム
      :actor_id => 618, :denominator => 6,
      :question => ["\\n<Liquor Slime>I want to devote myself to you...", "liqurslime_fc1", 0],
      :yes => ["\\n<Liquor Slime>Hehe, I'll heal you...", "liqurslime_fc1", 1],
      :no => ["\\n<Liquor Slime>No need for healing...? That's a shame.", "liqurslime_fc1", 2],
    },
    708 => { # スライムプリンセス
      :actor_id => 619, :denominator => 8,
      :question => ["\\n<Slime Princess>Lucky chance!I, the great me, will join your party!", "slimeprin_fc1", 0],
      :yes => ["\\n<Slime Princess>Ufufufufu~♪The fun adventure begins~!", "slimeprin_fc1", 1],
      :no => ["\\n<Slime Princess>Munyunyu~!!", "slimeprin_fc1", 2],
    },
    709 => { # アスラ
      :actor_id => 620, :denominator => 8,
      :question => ["\\n<Ashura>We are an honorable warrior race...I might lend you my strength.", "asura_fc1", 0],
      :yes => ["\\n<Ashura>Witness the power of my kin, praised as divine beings.", "asura_fc1", 1],
      :no => ["\\n<Ashura>You refuse my assistance and choose to walk a path of hardship on your own...", "asura_fc1", 2],
    },
    710 => { # ギガスライム
      :actor_id => 621, :denominator => 8,
      :question => ["\\n<Giga Slime>We're coming too...We want more companions...", "gigaslime_fc1", 2],
      :yes => ["\\n<Giga Slime>We'll absorb everyone...and become the ultimate being...", "gigaslime_fc1", 2],
      :no => ["\\n<Giga Slime>I see... How sad...", "gigaslime_fc1", 2],
    },
    713 => { # ラミアンナイトメア
      :actor_id => 622, :denominator => 8,
      :question => ["\\n<Nightmare Lamia>Fufu... I'll become your companion...", "lamia_n_fc1", 0],
      :yes => ["\\n<Nightmare Lamia>Fufu... Entertain me...", "lamia_n_fc1", 0],
      :no => ["\\n<Nightmare Lamia>I see...", "lamia_n_fc1", 0],
    },
    714 => { # ロードメデューサ
      :actor_id => 623, :denominator => 8,
      :question => ["\\n<Medusa Lord>I'll come along with you too...How about it, reassuring, isn't it?", "l_medusa_fc1", 0],
      :yes => ["\\n<Medusa Lord>Fufu, such an honest child...I'll have to give you a proper reward later.", "l_medusa_fc1", 1],
      :no => ["\\n<Medusa Lord>Hmph... I've lost interest.", "l_medusa_fc1", 2],
    },
    715 => { # パンドラ
      :actor_id => 624, :denominator => 10,
      :question => ["\\n<Pandora>The forbidden box is now yours...Come, take me with you...", "pandora_fc1", 0],
      :yes => ["\\n<Pandora>I will follow you wherever you go...To the one who opened the box...", "pandora_fc1", 1],
      :no => ["\\n<Pandora>Even though you opened the box...", "pandora_fc1", 2],
    },
    718 => { # ウツボ娘
      :actor_id => 625, :denominator => 4,
      :question => ["\\n<Moray Girl>Hey, let me join you too!", "utubom_fc1", 0],
      :yes => ["\\n<Moray Girl>Yay, looking forward to working with you~!", "utubom_fc1", 1],
      :no => ["\\n<Moray Girl>Slither, slither, slither...", "utubom_fc1", 2],
    },
    719 => { # アンシェントスキュラ
      :actor_id => 626, :denominator => 8,
      :question => ["\\n<Ancient Scylla>You seem like a rather lovely human.Very well, please let me join you.", "ancientscylla_fc1", 0],
      :yes => ["\\n<Ancient Scylla>Hehe... Nice to meet you.I will show you the power of the ancient Scylla.", "ancientscylla_fc1", 0],
      :no => ["\\n<Ancient Scylla>I-I see...", "ancientscylla_fc1", 2],
    },
    724 => { # 三口あかなめ
      :actor_id => 627, :denominator => 6,
      :question => ["\\n<Three-Mouthed Akaname>Wow, even my tongues couldn't beat you... I want to go to various places with a strong person.", "s_akaname_fc1", 0],
      :yes => ["\\n<Three-Mouthed Akaname>Yay~! I'll lick with all my might too♪", "s_akaname_fc1", 1],
      :no => ["\\n<Three-Mouthed Akaname>That's so mean...", "s_akaname_fc1", 2],
    },
    725 => { # 猫神
      :actor_id => 628, :denominator => 6,
      :question => ["\\n<Nekogami>Meow! Hime-chan wants to go with you too!", "nekogami_fc1", 0],
      :yes => ["\\n<Nekogami>Purr purr purr... Please take care of Hime-chan!", "nekogami_fc1", 0],
      :no => ["\\n<Nekogami>Eh~? Even with all this fawning, it's no good?", "nekogami_fc1", 1],
    },
    726 => { # 銀鬼
      :actor_id => 629, :denominator => 6,
      :question => ["\\n<Silver Oni>Would you take me on your journey as well...", "kizin_fc1", 0],
      :yes => ["\\n<Silver Oni>Well then, nice to meet you...", "kizin_fc1", 0],
      :no => ["\\n<Silver Oni>So it's 'Oni out'... is it?", "kizin_fc1", 1],
    },
    727 => { # 陰陽蠍
      :actor_id => 630, :denominator => 6,
      :question => ["\\n<Scorpio Taoist>Very well, take me with you. I shall show you the wonders of Taoism.", "onmyosasori_fc1", 1],
      :yes => ["\\n<Scorpio Taoist> Hohoho...you should look forward to it.  Enemies who face a concubine will only perish miserably.", "onmyosasori_fc1", 0], 
      :no => ["\\n<Scorpio Taoist> Are you saying that you don't need the power of a concubine...  This is also a strange combination of Taoism.", "onmyosasori_fc1", 2],
    },
    729 => { # ケット・シー
      :actor_id => 631, :denominator => 8,
      :question => ["\\n<Cait Sith> Atasimo, go!", "caitsith_fc1", 0],
      :yes => ["\\n<Cait Sith> Meow♪", "caitsith_fc1", 0],
      :no => ["\\n<Cait Sith> I hate you! I don't like it!", "caitsith_fc1", 2],
    },
    730 => { # ガルフォックス
      :actor_id => 632, :denominator => 8,
      :question => ["\\n<Gal Fox> I'm going to squeeze it... I'll try to make the concubine my friend too.  Kukuku, don't say you don't like it?", "galfox_fc1", 0],
      :yes => ["\\n<Gal Fox> The power of a concubine is vastly different from that of a real fox. If you look at , you should take a look...", "galfox_fc1", 0],
      :no => ["\\n<Gal Fox> Hmm, you're such a boring guy...", "galfox_fc1", 2],
    },
    732 => { # ジュラエイビス
      :actor_id => 633, :denominator => 8,
      :question => ["\\n<Jura Aevis> Hey, take me too!  I'll be your friend!", "juraabis_fc1", 0],
      :yes => ["\\n<Jura Aevis> Alright, leave it to me! I'll show you the power of a monster bird that has lived since ancient times!", "juraabis_fc1", 0],
      :no => ["\\n<Jura Abis>You're so cold, you!", "juraabis_fc1", 2],
    }, 
    733 => { # マルコシアス娘
      :actor_id => 634, :denominator => 8,
      :question => ["\\n<Marchosias Girl>I'll go with you too. Take me somewhere fun.", "marchosias_fc1", 0],
      :yes => ["\\n<Marchosias Girl>Alright, then. I'm pretty strong, you know.", "marchosias_fc1", 0],
      :no => ["\\n<Marchosias Girl>...Fine, do as you please.", "marchosias_fc1", 2],
    },
    736 => { # ローキュバス
      :actor_id => 635, :denominator => 6,
      :question => ["\\n<Loccubus>What a delicious-looking man... Do you have any intention of keeping me by your side?", "loccubus_fc1", 0],
      :yes => ["\\n<Loccubus>Hehehe, I'll show you a good dream...", "loccubus_fc1", 1],
      :no => ["\\n<Loccubus>Hmph, what a cold-hearted man...", "loccubus_fc1", 2],
    },
    737 => { # テスタロッサ
      :actor_id => 636, :denominator => 8,
      :question => ["\\n<Testarossa>Interesting, take me with you!", "testarossa_fc1", 0],
      :yes => ["\\n<Testarossa>Then let's go together! I don't know where we're going, though...", "testarossa_fc1", 1],
      :no => ["\\n<Testarossa>I-I see... Until we meet again.", "testarossa_fc1", 2],
    },
    738 => { # 上級海賊マーメイド
      :actor_id => 637, :denominator => 6,
      :question => ["\\n<Elite Pirate Mermaid>I fell in love with your SKL... May I come along with you?", "ek_mermaid_fc1", 0],
      :yes => ["\\n<Elite Pirate Mermaid>Today marks a new voyage... I'll follow you anywhere.", "ek_mermaid_fc1", 1],
      :no => ["\\n<Elite Pirate Mermaid>It seems you already have enough subordinates...", "ek_mermaid_fc1", 2],
    },
    739 => { # グレイトマーマン
      :actor_id => 638, :denominator => 8,
      :question => ["\\n<Great Merman>The seas of other worlds seem interesting too. Hey, won't you take me with you?", "greatmarman_fc1", 1],
      :yes => ["\\n<Great Merman>Then, I'm your companion. Show me the seas outside of the Monster Realm♪", "greatmarman_fc1", 1],
      :no => ["\\n<Great Merman>Being refused is quite humiliating...", "greatmarman_fc1", 2],
    },
    742 => { # ギガドライアド
      :actor_id => 639, :denominator => 10,
      :question => ["\\n<Giga Dryad>Can I come with you...?", "gigadryad_fc1", 0],
      :yes => ["\\n<Giga Dryad>I'm happy...", "gigadryad_fc1", 0],
      :no => ["\\n<Giga Dryad>That's unfortunate...", "gigadryad_fc1", 0],
    },
    745 => { # アルキュバス
      :actor_id => 640, :denominator => 6,
      :question => ["\\n<Arcubus>Um, may I come with you? It seems like it would help my research...", "arucubuss_fc1", 0],
      :yes => ["\\n<Arcubus> Well then, I'll join you~♪", "arucubuss_fc1", 0],
      :no => ["\\n<Arcubus> I see, this is rude...", "arucubuss_fc1", 2],
    },
    746 => { # レスキュバス
      :actor_id => 641, :denominator => 6,
      :question => ["\\n<Lescubus> You look so nice...  Can I go with you?", "lesscubuss_fc1", 0],
      :yes => ["\\n<Lescubus> Hehe, I won't let you get bored...  Of course, at night...♪", "lesscubuss_fc1", 1],
      :no => ["\\n<Lescubus> That's right...it seems like we had no connection.", "lesscubuss_fc1", 2],
    },
    747 => { # グラナバス
      :actor_id => 642, :denominator => 8,
      :question => ["\\n<Granabass> I found the best man...  Hey, won't you be mine...?", "granabass_fc1", 0],
      :yes => ["\\n<Granabass> Ufufu... I'll suck it all up...", "granabass_fc1", 0],
      :no => ["\\n<Granabass> Ah, the precious prey...", "granabass_fc1", 0],
    },
    753 => { # ハーゲンベック
      :actor_id => 643, :denominator => 8,
      :question => ["\\n<Hargenbeck> Could you take me too? I wanted to try traveling around the world~♪", "hargenbeck_fc2", 1],
      :yes => ["\\n<Hargenbeck> Wow, I'm so happy!  The Hargenbeck Circus is touring!", "hargenbeck_fc2", 1],
      :no => ["\\n<Hargenbeck> I want to tour!", "hargenbeck_fc2", 2],
    },
    755 => { # サンタマリア
      :actor_id => 644, :denominator => 8,
      :question => ["\\n<Santa Maria>Would you please take me?  It seems that there are many people who repent to my sacred doll...", "santamaria_fc2", 0],
      :yes => ["\\n<Santa Maria> Well then, let's go together. My Santa Maria accepts confessions from all.", "santamaria_fc2", 1],
      :no => ["\\n<Santa Maria> Giving an opportunity to repent is also a mercy...", "santamaria_fc2", 2],
    },
    757 => { # 切り裂きエリス
      :actor_id => 645, :denominator => 6,
      :question => ["\\n<Ellis the Ripper> Let's go, go, let's go together!", "elis_fc1", 0],
      :yes => ["\\n<Slicing Ellis> I'll cut all your enemies to pieces!", "elis_fc1", 1],
      :no => ["\\n<Slicing Ellis> Return, return...", "elis_fc1", 2],
    },
    759 => { # シャウトマータ
      :actor_id => 646, :denominator => 6,
      :question => ["\\n<Shout Mata> I would like to accompany you...", "shoutmata_fc1", 0],
      :yes => ["\\n<Shout Mata> Thank you for your continued support...", "shoutmata_fc1", 1],
      :no => ["\\n<Shout Mata> Jaan! Jaan!", "shoutmata_fc1", 3],
    },
    760 => { # ジャイアントセーラ
      :actor_id => 647, :denominator => 10,
      :question => ["\\n<Giant Serra>Next time, I want to play with you, big brother!Hey, is that okay...?", "giantsarah_fc1", 0],
      :yes => ["\\n<Giant Serra>Yay, we'll be together from now on♪Hey hey, what should we play?", "giantsarah_fc1", 1],
      :no => ["\\n<Giant Serra>Waaah!", "giantsarah_fc1", 2],
    },
    762 => { # パイズリ人形Mk.2
      :actor_id => 648, :denominator => 8,
      :question => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 0],
      :yes => ["\\n<Paizuri Doll Mk.2>............♪♪♪", "paizuridoll2_fc1", 0],
      :no => ["\\n<Paizuri Doll Mk.2>........................", "paizuridoll2_fc1", 2],
    },
    763 => { # ラブマータ
      :actor_id => 649, :denominator => 8,
      :question => ["\\n<Love Mata>Wouldn't you like a doll like me?", "lovemata_fc1", 0],
      :yes => ["\\n<Love Mata>Hehe... Do as you please♪", "lovemata_fc1", 1],
      :no => ["\\n<Love Mata>I see... You're so innocent.", "lovemata_fc1", 2],
    },
    765 => { # ブラヴァツキー
      :actor_id => 650, :denominator => 8,
      :question => ["\\n<Blavatsky>I... will go too...", "blavatsky_fc1", 0],
      :yes => ["\\n<Blavatsky>Stay... with me...", "blavatsky_fc1", 0],
      :no => ["\\n<Blavatsky> Don't leave me behind...", "blavatsky_fc1", 2],
    },
    767 => { # 決戦人型兵器アグニ
      :actor_id => 651, :denominator => 10,
      :question => ["\\n<Humanoid Decisive Weapon Agni> I am a weapon, fitting only for those who fight...", "aguni_fc1", 0],
      :yes => ["\\n<Humanoid Decisive Weapon Agni> I will destroy all enemies!", "aguni_fc1", 1],
      :no => ["\\n<Humanoid Decisive Weapon Agni> Are you saying weapons are unnecessary...", "aguni_fc1", 2],
    },
    768 => { # 快楽人形・雅姫
      :actor_id => 652, :denominator => 10,
      :question => ["\\n<Pleasure Doll Miyabi> Hmm, quite a warrior... Would you like to have a doll like me at your side?", "miyabihime_fc1", 0],
      :yes => ["\\n<Pleasure Doll Miyabi> Very well, I shall intoxicate you with the ultimate pleasure...", "miyabihime_fc1", 1],
      :no => ["\\n<Pleasure Doll Miyabi> Hmm, to be rejected... It seems my charm still needs work.", "miyabihime_fc1", 3],
    },
    773 => { # ナンキュバス
      :actor_id => 653, :denominator => 4,
      :question => ["\\n<Nankyubus> Hey, hey, take me with you too~!", "nanccubus_fc1", 0],
      :yes => ["\\n<Nankyubus> Well then, nice to meet you~! By the way, where are we going to play...?", "nanccubus_fc1", 0],
      :no => ["\\n<Nankyubus> Well then, see you again~!", "nanccubus_fc1", 0],
    },
    774 => { # パビルサグ
      :actor_id => 654, :denominator => 6,
      :question => ["\\n<Pabilsag>Ku ku ku... Quite amusing. As the strongest of the insect species, I shall lend you my power.", "pabilsag_fc1", 0],
      :yes => ["\\n<Pabilsag>We are the strongest of the insect species. Everything shall perish by my poisonous sting...", "pabilsag_fc1", 0],
      :no => ["\\n<Pabilsag>Hmph... You refuse to borrow the power of insects?", "pabilsag_fc1", 2],
    },
    775 => { # マンイーター
      :actor_id => 655, :denominator => 8,
      :question => ["\\n<Maneater>Hey, big brother... Take me with you, too. I'm so hungry...", "maneater_fc1", 0],
      :yes => ["\\n<Maneater>Hehe... I wonder if I can eat a lot? Let's go to various places, big brother♪", "maneater_fc1", 0],
      :no => ["\\n<Maneater>Hmph, you're going to leave me behind... Fine, I'll do whatever I want♪", "maneater_fc1", 2],
    },
    776 => { # 古代竜
      :actor_id => 656, :denominator => 10,
      :question => ["\\n<Ancient Dragon>You, you're quite a skilled one. You are worthy of borrowing the power of an ancient dragon.", "kodairyu_fc1", 1],
      :yes => ["\\n<Ancient Dragon>Dragons are the strongest among all creatures. Let me show you that.", "kodairyu_fc1", 1],
      :no => ["\\n<Ancient Dragon>Hmph, I won't eat you...", "kodairyu_fc1", 2],
    },
    782 => { # ハイバフォメット
      :actor_id => 659, :denominator => 6,
      :question => ["\\n<High Baphomet>To think such a strong one existed... Very well, take me with you.", "high_baphomet_fc1", 0],
      :yes => ["\\n<High Baphomet> You can rely on my arms to the fullest!", "high_baphomet_fc1", 1],
      :no => ["\\n<High Baphomet> Hmm, are you saying you don't need my power...", "high_baphomet_fc1", 2],
    },
    783 => { # ローグエルフ
      :actor_id => 660, :denominator => 6,
      :question => ["\\n<Rogue Elf> You're amazing!  Take me too!", "rogueelf_fc1", 0],
      :yes => ["\\n<Rogue Elf> Even with this, your bow SKL are outstanding!  Let's go in high spirits!", "rogueelf_fc1", 1],
      :no => ["\\n<Rogue Elf> Yeah~? I'm getting excited...", "rogueelf_fc1", 2],
    },
    807 => { # ガーゴイル娘
      :actor_id => 661, :denominator => 8,
      :question => ["\\n<Gargoyle Girl> It's been a while since an interesting person came.  Kuku, I'll go with you...", "gargoyle_fc1", 0],
      :yes => ["\\n<Gargoyle Girl> It's been a while since I moved.  The entire pedestal... Ugggggg...", "gargoyle_fc1", 2],
      :no => ["\\n<Gargoyle Girl> Hmm, I'm used to waiting...", "gargoyle_fc1", 2],
    },
    808 => { # アテナ
      :actor_id => 662, :denominator => 8,
      :question => ["\\n<Athena> Let me specially help you. Although it is a demon, it is imbued with holy power.", "athena_fc1", 0],
      :yes => ["\\n<Athena> Well then, let's go together. If you need sacred magic or recovery, please leave it to me.", "athena_fc1", 1],
      :no => ["\\n<Athena>Are you also going to exclude me...?", "athena_fc1", 2],
    },
    812 => { # 阿吽
      :actor_id => 663, :denominator => 8,
      :question => ["\\n<Aun>Hey! Take me! Take me!", "aun_fc1", 0],
      :yes => ["\\n<Aun>Let's go! Let's go!", "aun_fc1", 1],
      :no => ["\\n<Aun>You're stingy! Narrow-minded!", "aun_fc1", 2],
    },
    813 => { # ドラゴンヘッド
      :actor_id => 664, :denominator => 8,
      :question => ["\\n<Dragon Head>Won't you make me your companion? I will definitely be useful in your adventure!", "dragonhead_fc1", 0],
      :yes => ["\\n<Dragon Head>Then, let's go together! I will fully wield the power of this dragon!", "dragonhead_fc1", 1],
      :no => ["\\n<Dragon Head>W-what, you don't need me!?", "dragonhead_fc1", 2],
    },
    814 => { # モンストロ
      :actor_id => 665, :denominator => 10,
      :question => ["\\n<Monstro>Take me with you! Take me with you!", "monstruo_fc1", 0],
      :yes => ["\\n<Monstro>Companion! Companion~!", "monstruo_fc1", 1],
      :no => ["\\n<Monstro>Waaah!!", "monstruo_fc1", 2],
    },
    815 => { # シヴァ
      :actor_id => 666, :denominator => 8,
      :question => ["\\n<Shiva> You're quite an interesting man.  Very well, I shall lend you my strength.", "siva_fc1", 0],
      :yes => ["\\n<Shiva> Hmm... Use my sword well.  Now, shall we go?", "siva_fc1", 1],
      :no => ["\\n<Shiva> You haven't underestimated my power, have you?", "siva_fc1", 2],
    },
    817 => { # ネプチューン
      :actor_id => 667, :denominator => 10,
      :question => ["\\n<Neptune> Take me with you...  I shall sink everything into the sea...", "neptune_fc1", 0],
      :yes => ["\\n<Neptune> That's fine...  My wish is to submerge the world...", "neptune_fc1", 0],
      :no => ["\\n<Neptune> The world will sink into the sea anyway...", "neptune_fc1", 0],
    },
    818 => { # タオ
      :actor_id => 668, :denominator => 10,
      :question => ["\\n<Tao> Interesting... I like you.  Become my servant...", "tao_fc1", 0],
      :yes => ["\\n<Tao> Good, now you are my servant...", "tao_fc1", 0],
      :no => ["\\n<Tao> Why? What are you dissatisfied with...!?", "tao_fc1", 2],
    },
    819 => { # モルボル娘
      :actor_id => 669, :denominator => 10,
      :question => ["\\n<Malboro Girl> Hey, won't you take me with you?  If you can stand the smell... that is.", "moruboru_fc1", 0],
      :yes => ["\\n<Malboro Girl>So, you like unusual things... Since you accepted me, I'll do my best.", "moruboru_fc1", 1],
      :no => ["\\n<Malboro Girl>It really does smell, doesn't it...", "moruboru_fc1", 2],
    },
    820 => { # アルケオプテリクス
      :actor_id => 670, :denominator => 10,
      :question => ["\\n<Archaeopteryx>I hate being alone... Please take me with you...", "a_pterix_fc1", 0],
      :yes => ["\\n<Archaeopteryx>Now, I'm part of the team... I'm not alone anymore...", "a_pterix_fc1", 1],
      :no => ["\\n<Archaeopteryx>I've been alone for so long... I am alone...", "a_pterix_fc1", 2],
    },
    821 => { # アスモデウス
      :actor_id => 671, :denominator => 10,
      :question => ["\\n<Asmodeus>Ahaha, I like you. I'll make you my servant...", "asmodeus_fc1", 0],
      :yes => ["\\n<Asmodeus>Then, come with me. You can decide where we go.", "asmodeus_fc1", 0],
      :no => ["\\n<Asmodeus>You don't bow before me... Then I have no use for you.", "asmodeus_fc1", 2],
    },
    822 => { # ヨルムンガンド
      :actor_id => 672, :denominator => 10,
      :question => ["\\n<Jormungandr>Oh, you're an interesting human. Very well, I'll lend you my strength.", "jormungand_fc1", 0],
      :yes => ["\\n<Jormungandr>I'm among the highest-ranked lamias in the Monster Realm. I won't fall behind those common rabble.", "jormungand_fc1", 0],
      :no => ["\\n<Jormungandr>I see... Well, it can't be helped.", "jormungand_fc1", 2],
    },

    828 => { # 前鬼
      :actor_id => 432, :denominator => 6,
      :question => ["\\n<Zenki>I've taken a liking to you.\nIf you make me your friend, I'll work really hard for you!", "zenki_fc1", 0],
      :yes => ["\\n<Zenki>Hahaha, looks like I'm gonna have fun from now on!", "zenki_fc1", 1],
      :no => ["\\n<Zenki>The contract was unsuccessful...? That's too bad.", "zenki_fc1", 2],
    },
    829 => { # 後鬼
      :actor_id => 433, :denominator => 6,
      :question => ["\\n<Kouki>You're really good.\nWould you take me along as well?", "kouki_fc1", 0],
      :yes => ["\\n<Kouki>I'll work my hardest for you...\nAs a friend, and nothing more.", "kouki_fc1", 1],
      :no => ["\\n<Kouki>You're not very nice...", "kouki_fc1", 2],
    },
    832 => { # 失墜の玉座
      :actor_id => 848, :denominator => 6,
      :question => ["\\n<Fallen Throne>I wait, on the throne of the heavens...In the seat of desire, I await those who seek...", "s_gyokuza_fc1", 0],
      :yes => ["\\n<Fallen Throne>Seek and appeal...Holy is the eternal seat that shall come.", "s_gyokuza_fc1", 0],
      :no => ["\\n<Fallen Throne>I wait, on the throne of the heavens...For those who sit in the light...", "s_gyokuza_fc1", 0],
    },
    833 => { # ダブルアンデッド
      :actor_id => 849, :denominator => 6,
      :question => ["\\n<Double Undead>I want to go with you too...", "doubleundead_fc1", 0],
      :yes => ["\\n<Double Undead>Let's go together...", "doubleundead_fc1", 0],
      :no => ["\\n<Double Undead>Don't leave me behind...", "doubleundead_fc1", 0],
    },
    834 => { # イズン
      :actor_id => 850, :denominator => 10,
      :question => ["\\n<Idun>Make me your companion too~!", "izun_fc1", 0],
      :yes => ["\\n<Idun>Yay! We'll be together from now on!", "izun_fc1", 1],
      :no => ["\\n<Idun>Sniff...", "izun_fc1", 2],
    },
    835 => { # カースエンジェルズ
      :actor_id => 851, :denominator => 10,
      :question => ["\\n<Curse Angels> Fufu, ufufufufufu...", "carthangels_fc1", 0],
      :yes => ["\\n<Curse Angels> Ufufufufufu...", "carthangels_fc1", 0],
      :no => ["\\n<Curse Angels> ................", "carthangels_fc1", 0],
    },
    838 => { # アルジェミニ
      :actor_id => 852, :denominator => 10,
      :question => ["\\n<Algemini> I am the highest-ranking Apoptosis... I might lend you my strength as a special favor.", "algemini_fc1", 0],
      :yes => ["\\n<Algemini> I'll blast any foe away with this cannon. Just make sure you don't get caught in the blast.", "algemini_fc1", 0],
      :no => ["\\n<Algemini> You're a boring human...", "algemini_fc1", 2],
    },
    839 => { # エルジェミニ
      :actor_id => 853, :denominator => 10,
      :question => ["\\n<Elgemini> I am the highest-ranking Apoptosis... I shall lend you my strength as a special favor.", "elgemini_fc1", 0],
      :yes => ["\\n<Elgemini> I'll slice any enemy to pieces with this blade. I hope you don't get caught in it...", "elgemini_fc1", 0],
      :no => ["\\n<Elgemini> You're a dull human...", "elgemini_fc1", 2],
    },
    843 => { # シェムハザ
      :actor_id => 854, :denominator => 10,
      :question => ["\\n<Samyaza> I wish to accompany you...", "shemhaza_fc1", 0],
      :yes => ["\\n<Samyaza>I will now support the achievement of the goal...", "shemhaza_fc1", 0],
      :no => ["\\n<Samyaza>........................", "shemhaza_fc1", 2],
    },
    844 => { # アグレイブ
      :actor_id => 855, :denominator => 10,
      :question => ["\\n<Agrave>I want to go outside too. Because, it must be very fun, right...?", "agrave_fc1", 0],
      :yes => ["\\n<Agrave>Well, I'm happy. Now, let's go outside...", "agrave_fc1", 1],
      :no => ["\\n<Agrave>I don't like it here... Someone, take me out of here...", "agrave_fc1", 2],
    },
    848 => { # スターマ
      :actor_id => 856, :denominator => 10,
      :question => ["\\n<Starma>To fulfill your destinies... I shall accompany you.", "starma_fc1", 0],
      :yes => ["\\n<Starma>Hehe, I shall guide you to your fate...", "starma_fc1", 0],
      :no => ["\\n<Starma>To reject the guidance of fate...", "starma_fc1", 2],
    },
    849 => { # ラジャーラ
      :actor_id => 857, :denominator => 10,
      :question => ["\\n<Rajara>I like you, take me with you!", "rajara_fc1", 0],
      :yes => ["\\n<Rajara>Haha, from now on we're comrades!", "rajara_fc1", 0],
      :no => ["\\n<Rajara>Well, you're cold-hearted...", "rajara_fc1", 2],
    },
    851 => { # メギドリアード
      :actor_id => 858, :denominator => 10,
      :question => ["\\n<Megiddryad>Please, take me with you too...", "megidryad_fc1", 0],
      :yes => ["\\n<Megiddryad>Fufu, it looks like I'll have some enjoyable experiences...", "megidryad_fc1", 0],
      :no => ["\\n<Megiddryad>You're so heartless...", "megidryad_fc1", 2],
    },
    852 => { # エグセラ
      :actor_id => 859, :denominator => 10,
      :question => ["\\n<Exsera>Show me the scenes of destruction...", "exsera_fc1", 0],
      :yes => ["\\n<Exsera>Let's enjoy the end of the world...", "exsera_fc1", 0],
      :no => ["\\n<Exsera>Oh, that's unfortunate...", "exsera_fc1", 2],
    },
    853 => { # アプサラス
      :actor_id => 860, :denominator => 10,
      :question => ["\\n<Apsara>Don't you want to always watch my dance by your side...?", "apsaras_fc1", 0],
      :yes => ["\\n<Apsara>Fufu, I'll brighten up our journey with my dance...", "apsaras_fc1", 0],
      :no => ["\\n<Apsara>My pride is wounded...!", "apsaras_fc1", 2],
    },
    862 => { # ゾルオクト
      :actor_id => 861, :denominator => 10,
      :question => ["\\n<Zoloct>Please, take me with you, won't you?I want to fill this unit with energetic gentlemen...", "zoloct_fc1", 0],
      :yes => ["\\n<Zoloct>Well then, let's go.If you ever feel like joining inside, please do.", "zoloct_fc1", 0],
      :no => ["\\n<Zoloct>Is it no good...? That's unfortunate.", "zoloct_fc1", 2],
    },
    863 => { # ティアマト
      :actor_id => 862, :denominator => 20,
      :question => ["\\n<Tiamat>There is no one faster than me...I will prove it to you.", "tiamat_fc1", 0],
      :yes => ["\\n<Tiamat>Yes... I am the fastest.There is nothing that can catch up with me.", "tiamat_fc1", 1],
      :no => ["\\n<Tiamat>Hmph, I refuse from my side...", "tiamat_fc1", 2],
    },
    871 => { # アプティルト
      :actor_id => 863, :denominator => 10,
      :question => ["\\n<Aptilt> I ■■■■■ke...", "aptiel_fc1", 1],
      :yes => ["\\n<Aptilt>■■■■■■■■■...", "aptiel_fc1", 1],
      :no => ["\\n<Aptilt>■■■■■■■■...", "aptiel_fc1", 1],
    },
    872 => { # アムナリオ
      :actor_id => 864, :denominator => 20,
      :question => ["\\n<Amunario>Sounds interesting... Take me with you.", "amnario_fc1", 0],
      :yes => ["\\n<Amunario>Hehe, this looks like it'll be plenty of fun...", "amnario_fc1", 0],
      :no => ["\\n<Amunario>I see... How boring.", "amnario_fc1", 2],
    },
    873 => { # サマエル
      :actor_id => 865, :denominator => 10,
      :question => ["\\n<Samael>Ahaha, you're pretty good!Shall I go with you too?", "samael_fc1", 0],
      :yes => ["\\n<Samael>Watch my gun SKL!I can hit any enemy with a single shot!", "samael_fc1", 1],
      :no => ["\\n<Samael>Is my gun that unreliable...?", "samael_fc1", 5],
    },
    874 => { # シャドウアサシン
      :actor_id => 866, :denominator => 10,
      :question => ["\\n<Shadow Assassin>I shall become your shadow...", "shadowassassin_fc1", 0],
      :yes => ["\\n<Shadow Assassin>The shadow only follows...", "shadowassassin_fc1", 0],
      :no => ["\\n<Shadow Assassin>........................", "shadowassassin_fc1", 0],
    },
    875 => { # 正体不明
      :actor_id => 867, :denominator => 10,
      :question => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :yes => ["\\n<Unknown>........................", "unknown1_fc1", 0],
      :no => ["\\n<Unknown>........................", "unknown1_fc1", 0],
    },
    876 => { # 正体不明
      :actor_id => 868, :denominator => 10,
      :question => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :yes => ["\\n<Unknown>........................", "unknown2_fc1", 0],
      :no => ["\\n<Unknown>........................", "unknown2_fc1", 0],
    },
    877 => { # 正体不明
      :actor_id => 869, :denominator => 10,
      :question => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :yes => ["\\n<Unknown>........................", "unknown3_fc1", 0],
      :no => ["\\n<Unknown>........................", "unknown3_fc1", 0],
    },
    878 => { # 正体不明
      :actor_id => 870, :denominator => 10,
      :question => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :yes => ["\\n<Unknown>........................", "unknown4_fc1", 0],
      :no => ["\\n<Unknown>........................", "unknown4_fc1", 0],
    },
    879 => { # 正体不明
      :actor_id => 871, :denominator => 10,
      :question => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :yes => ["\\n<Unknown>........................", "unknown5_fc1", 0],
      :no => ["\\n<Unknown>........................", "unknown5_fc1", 0],
    },
    881 => { # バンシィ
      :actor_id => 872, :denominator => 10,
      :question => ["\\n<Banshee>I want to travel with you all...", "curseloreley_fc1", 0],
      :yes => ["\\n<Banshee> Let's go anywhere together…", "curseloreley_fc1", 0],
      :no => ["\\n<Banshee> I wanted to travel…", "curseloreley_fc1", 2],
    },
    882 => { # ボアバンシィ
      :actor_id => 873, :denominator => 10,
      :question => ["\\n<Vore Banshee> Hey, take me with you!", "voremermaid_fc1", 0],
      :yes => ["\\n<Vore Banshee> Hehe, I'll do my best…!", "voremermaid_fc1", 0],
      :no => ["\\n<Vore Banshee> How unfortunate…", "voremermaid_fc1", 2],
    },
    884 => { # パズズ
      :actor_id => 874, :denominator => 10,
      :question => ["\\n<Pazuzu> Take me! Take me!", "pazuzu_fc1", 0],
      :yes => ["\\n<Pazuzu> Let's go together! Let's go!", "pazuzu_fc1", 0],
      :no => ["\\n<Pazuzu> Muu!!", "pazuzu_fc1", 2],
    },
    885 => { # マステマ
      :actor_id => 875, :denominator => 10,
      :question => ["\\n<Mastema> It seems like it would be fun with you all…", "masutema_fc1", 0],
      :yes => ["\\n<Mastema> I'll enjoy myself to the fullest…", "masutema_fc1", 0],
      :no => ["\\n<Mastema> Remember ...!", "masutema_fc1", 2],
    },
    888 => { # アメノハヅチ
      :actor_id => 876, :denominator => 10,
      :question => ["\\n<Ame no Hazuchi>  Me too... let's go...", "amenohaduti_fc1", 0],
      :yes => ["\\n<Ame no Hazuchi>  Hehe...hehehehe...", "amenohaduti_fc1", 1],
      :no => ["\\n<Ame no Hazuchi>  Curse me... I'll do it...", "amenohaduti_fc1", 2],
    },
    889 => { # 八尺様
      :actor_id => 877, :denominator => 10,
      :question => ["\\n<Hasshaku-sama>  Pop, Popopo, Popopopo...", "hasyakusama_fc1", 0],
      :yes => ["\\n<Hasshaku-sama>  Popopopopopopopopopopopyyyyyyyx", "hasyakusama_fc1", 0],
      :no => ["\\n<Hasshaku-sama>  Popopo...", "hasyakusama_fc1", 2],
    },
    907 => { # ゲシュタルト
      :actor_id => 878, :denominator => 10,
      :question => ["\\n<Gestalt>  Could you please take me with you...?", "gestalt_fc1", 0],
      :yes => ["\\n<Gestalt>  Hehe, at least it's useful...", "gestalt_fc1", 0],
      :no => ["\\n<Gestalt>  What don't you like about it...?", "gestalt_fc1", 2],
    },
    908 => { # ハイブマインド
      :actor_id => 879, :denominator => 10,
      :question => ["\\n<Hivemind>I want to go with you too~!", "hivemind_fc1", 0],
      :yes => ["\\n<Hivemind>Yay! I'll work really hard~!", "hivemind_fc1", 0],
      :no => ["\\n<Hivemind>Mugyuu...", "hivemind_fc1", 2],
    },
    913 => { # マダムラミア
      :actor_id => 880, :denominator => 10,
      :question => ["\\n<Madame Lamia>Oh, how lovely... I want to go with you too.", "madamlamia_fc1", 0],
      :yes => ["\\n<Madame Lamia>Fufu... Let's have some fun.", "madamlamia_fc1", 0],
      :no => ["\\n<Madame Lamia>You've smeared mud on my face...", "madamlamia_fc1", 2],
    },
    922 => { # サタナキア
      :actor_id => 881, :denominator => 10,
      :question => ["\\n<Satanachia>Interesting, I'll go with you too...", "satanachia_fc1", 0],
      :yes => ["\\n<Satanachia>Kukuku, rely on my power!", "satanachia_fc1", 0],
      :no => ["\\n<Satanachia>Muu, how boring...", "satanachia_fc1", 2],
    },
    923 => { # ブラッディドラゴン
      :actor_id => 882, :denominator => 20,
      :question => ["\\n<Bloody Dragon>Your power is quite something... I'll see the end of your journey.", "bloddydragon_fc1", 0],
      :yes => ["\\n<Bloody Dragon> Kuku...don't bore me.", "bloddydragon_fc1", 0],
      :no => ["\\n<Bloody Dragon> Why...!", "bloddydragon_fc1", 2],
    },
    928 => { # パイズリ人形終異体
      :actor_id => 883, :denominator => 10,
      :question => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 0],
      :yes => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 0],
      :no => ["\\n<Final Paizuri Doll>……………………", "paizuridoll3_fc1", 2],
    },
    929 => { # アイアンメイデン終異体
      :actor_id => 884, :denominator => 10,
      :question => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 0],
      :yes => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 0],
      :no => ["\\n<Final Iron Maiden>……………………", "ironmaiden_s_fc1", 2],
    },
    930 => { # 呪いの人形終異体
      :actor_id => 885, :denominator => 10,
      :question => ["\\n<Final Cursed Doll> I want to go too...", "doll_itai_fc1", 0],
      :yes => ["\\n<Final Cursed Doll>fufufufufufufufu...", "doll_itai_fc1", 1],
      :no => ["\\n<Final Cursed Doll> I will curse you...", "doll_itai_fc1", 2],
    },
    932 => { # マグダ
      :actor_id => 886, :denominator => 10,
      :question => ["\\n<Magda> Show me your future...", "magda_fc1", 0],
      :yes => ["\\n<Magda> I'm always watching...", "magda_fc1", 0],
      :no => ["\\n<Magda> I can't see anything...", "magda_fc1", 2],
    },
    933 => { # シスエル
      :actor_id => 887, :denominator => 20,
      :question => ["\\n<Sisel>Won't you take me with you too...?", "sisel_fc1", 0],
      :yes => ["\\n<Sisel>It doesn't seem like I'll be bored for a while...", "sisel_fc1", 0],
      :no => ["\\n<Sisel>I see, how boring...", "sisel_fc1", 1],
    },
    934 => { # アザゼル
      :actor_id => 888, :denominator => 10,
      :question => ["\\n<Azazel>Let's go together...", "azazel_fc1", 0],
      :yes => ["\\n<Azazel>Show me how you save the world...", "azazel_fc1", 0],
      :no => ["\\n<Azazel>That's unfortunate...", "azazel_fc1", 1],
    },
    935 => { # グリゴリ
      :actor_id => 889, :denominator => 10,
      :question => ["\\n<Grigori>Hehe, I want to go with you too...", "grigori_fc1", 0],
      :yes => ["\\n<Grigori>I'll watch over you as you fight...", "grigori_fc1", 0],
      :no => ["\\n<Grigori>This too is fate...", "grigori_fc1", 1],
    },
    944 => { # 奉仕種族
      :actor_id => 892, :denominator => 10,
      :question => ["\\n<Serviceborne>I shall serve you...", "houshi_fc1", 0],
      :yes => ["\\n<Serviceborne> From now on, always...", "houshi_fc1", 0],
      :no => ["\\n<Serviceborne>……………………", "houshi_fc1", 2],
    },
    945 => { # 落とし子
      :actor_id => 893, :denominator => 20,
      :question => ["\\n<Forsaken Spawn> I saw the guidance...", "spawn_fc1", 0],
      :yes => ["\\n<Forsaken Spawn> My destiny is with you...", "spawn_fc1", 0],
      :no => ["\\n<Forsaken Spawn> The position of the star is not good...", "spawn_fc1", 2],
    },
    947 => { # 触手の眷属
      :actor_id => 894, :denominator => 10,
      :question => ["\\n<Tentacle Kin> Would you like to take me too...?", "zigen_kenzoku_fc1", 0],
      :yes => ["\\n<Tentacle Kin> Hehe, it's time to depart...", "zigen_kenzoku_fc1", 0],
      :no => ["\\n<Tentacle Kin> My dream of leaving has been crushed...", "zigen_kenzoku_fc1", 2],
    },
    948 => { # 粘膜の眷属
      :actor_id => 895, :denominator => 10,
      :question => ["\\n<Mucous membrane kin> I want your journey to be slippery...", "zigen_kenzoku2_fc1", 0],
      :yes => ["\\n<Mucous membrane dependent> Hehe, let's get slimy together...", "zigen_kenzoku2_fc1", 0],
      :no => ["\\n<Mucous membrane kin> I hate slimy things...?", "zigen_kenzoku2_fc1", 2],
    },
    949 => { # アウタージェリー
      :actor_id => 896, :denominator => 20,
      :question => ["\\n<Outer Jelly> Shall I go with you too...?", "outerjelly_fc1", 0],
      :yes => ["\\n<Outer Jerry> Hehe, nice to meet you...", "outerjelly_fc1", 0],
      :no => ["\\n<Outer Jelly> Oh, that's a shame... Maybe another time...", "outerjelly_fc1", 0],
    },
    950 => { # アウターワーム
      :actor_id => 897, :denominator => 20,
      :question => ["\\n<Outer Worm> I want to go with you...", "outerworm_fc1", 0],
      :yes => ["\\n<Outer Worm>fufufufufu...", "outerworm_fc1", 1],
      :no => ["\\n<Outer Worm>……………………", "outerworm_fc1", 0],
    },
    956 => { # ヌルの眷属
      :actor_id => 898, :denominator => 10,
      :question => ["\\n<Null Kin> Kyu! Squeaky!", "null_kenzoku_fc1", 0],
      :yes => ["\\n<Null Kin> Kyu! Squeak!", "null_kenzoku_fc1", 0],
      :no => ["\\n<Null Kin> Kyu...", "null_kenzoku_fc1", 0],
    },
    957 => { # ヌルの眷属
      :actor_id => 899, :denominator => 10,
      :question => ["\\n<Null Kin> Squeaky kyukyu kyukyu~!", "null_kenzoku_fc1", 1],
      :yes => ["\\n<Null Kin> Squeaky!", "null_kenzoku_fc1", 1],
      :no => ["\\n<Null Kin> Kyukyu...", "null_kenzoku_fc1", 1],
    },
    958 => { # ヌルの眷属
      :actor_id => 900, :denominator => 10,
      :question => ["\\n<Null Kin> Kyu... Kyu Kyu Kyu!", "null_kenzoku_fc1", 2],
      :yes => ["\\n<Null Kin> Kyu! Squeak!", "null_kenzoku_fc1", 2],
      :no => ["\\n<Null Kin> Squeaky...?", "null_kenzoku_fc1", 2],
    },
    959 => { # TT
      :actor_id => 901, :denominator => 10,
      :question => ["\\n<TT>myumyuu, myumyumyu~!", "TT_fc1", 0],
      :yes => ["\\n<TT>myu! Myuu~!", "TT_fc1", 0],
      :no => ["\\n<TT>myumyu……", "TT_fc1", 2],
    },
    960 => { # QQ
      :actor_id => 902, :denominator => 20,
      :question => ["QQ", "QQ_fc1", 0],
      :yes => ["QQ", "QQ_fc1", 0],
      :no => ["QQ", "QQ_fc1", 2],
    },
    962 => { # グラン・アラーニェ
      :actor_id => 903, :denominator => 10,
      :question => ["\\n<Grand Arachne> Hehe, won't you take me too...?", "gran_arachne_fc1", 0],
      :yes => ["\\n<Grand Arachne>I'm happy, let's have fun together...", "gran_arachne_fc1", 0],
      :no => ["\\n<Grand Arachne>How mortifying...", "gran_arachne_fc1", 2],
    },
    973 => { # インドラ
      :actor_id => 905, :denominator => 10,
      :question => ["\\n<Indra>I shall lend you my strength too!", "indora_fc1", 0],
      :yes => ["\\n<Indra>Hahaha, I'll go wild to my heart's content!", "indora_fc1", 0],
      :no => ["\\n<Indra>You don't need my strength...?", "indora_fc1", 2],
    },
    974 => { # トンベリ娘
      :actor_id => 904, :denominator => 20,
      :question => ["\\n<Tonberry Girl>................", "tonberi_fc1", 0],
      :yes => ["\\n<Tonberry Girl>................", "tonberi_fc1", 0],
      :no => ["\\n<Tonberry Girl>................", "tonberi_fc1", 2],
    },
    976 => { # アバドン
      :actor_id => 906, :denominator => 20,
      :question => ["\\n<Abaddon>Take me with you. I'll destroy everything for you.", "abaddon_fc1", 0],
      :yes => ["\\n<Abaddon>Hehe, I'll crush everything for you...", "abaddon_fc1", 0],
      :no => ["\\n<Abaddon>I see, how rude...", "abaddon_fc1", 2],
    },
    977 => { # エクスキュウビ
      :actor_id => 907, :denominator => 20,
      :question => ["\\n<EX-Kyubi>I wish to accompany you...", "exkyubi_fc1", 0],
      :yes => ["\\n<EX-Kyubi>I appreciate it, let's conquer together...", "exkyubi_fc1", 0],
      :no => ["\\n<EX-Kyubi>That's unfortunate...", "exkyubi_fc1", 0],
    },
    978 => { # ドーラドーラ
      :actor_id => 908, :denominator => 20,
      :question => ["\\n<Dolla-Dolla>Me too, together...", "dolladolla_fc1", 0],
      :yes => ["\\n<Dolla-Dolla>Always together...", "dolladolla_fc1", 0],
      :no => ["\\n<Dolla-Dolla>..................", "dolladolla_fc1", 2],
    },
    979 => { # ベルゼバブ終異体
      :actor_id => 909, :denominator => 20,
      :question => ["\\n<Final Beelzebub>I feel a sense of fate with you.Won't you take me along too?", "beelzebub_s_fc1", 0],
      :yes => ["\\n<Final Beelzebub>Thank you, I'll fight with all my might!", "beelzebub_s_fc1", 0],
      :no => ["\\n<Final Beelzebub>I felt a sense of fate...", "beelzebub_s_fc1", 2],
    },
    980 => { # メルカヴァ
      :actor_id => 910, :denominator => 20,
      :question => ["\\n<Merkabah>The chaos of prayers, the chariot of God and the warship of demons.Angels and children of men, move me...", "merkava_fc1", 0],
      :yes => ["\\n<Merkabah>Now, let's return everything to chaos.Entropy will collapse, returning to the proper chaos...", "merkava_fc1", 1],
      :no => ["\\n<Merkabah> Everything will lead to chaos...  That truth will not change...", "merkava_fc1", 2],
    },
    981 => { # フレール
      :actor_id => 911, :denominator => 20,
      :question => ["\\n<Frere> Take me too...", "ozum_fc1", 0],
      :yes => ["\\n<Frere> From now on, friends...", "ozum_fc1", 0],
      :no => ["\\n<Frere> Yes...", "ozum_fc1", 1],
    },
    982 => { # アガリアレプト
      :actor_id => 912, :denominator => 20,
      :question => ["\\n<Agalialept> Interesting, show me your fate...", "agaliarept_fc1", 0],
      :yes => ["\\n<Agalialept> Hehe, I will see to you.", "agaliarept_fc1", 0],
      :no => ["\\n<Agaliarept> Hmm, then I don't really care...", "agaliarept_fc1", 2],
    },
    983 => { # ゲイザー
      :actor_id => 913, :denominator => 20,
      :question => ["\\n<Gazer> Hey, would you like to have me as a friend?", "gazer_fc1", 0],
      :yes => ["\\n<Gazer> It's okay, I'll lend you my strength.  No matter what enemy I am, my eyesight is the best!", "gazer_fc1", 0],
      :no => ["\\n<Gazer> It makes me nervous...", "gazer_fc1", 2],
    },
    984 => { # ベリアル
      :actor_id => 914, :denominator => 20,
      :question => ["\\n<Belial>I am Belial, I shall conquer with you!", "berial_fc1", 0],
      :yes => ["\\n<Belial>Hahahaha! There are no enemies before my power!", "berial_fc1", 0],
      :no => ["\\n<Belial>Grrr, this is humiliating...", "berial_fc1", 2],
    },



  }
end



